/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.param;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.DynamicDbType;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.domain.type.UnknownDbTypeException;
import org.mule.module.db.internal.resolver.param.DefaultParamTypeResolver;
import org.mule.module.db.internal.resolver.param.ParamTypeResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DefaultParamTypeResolverTestCase
extends AbstractMuleTestCase {
    public static final String SQL_TEXT = "select * from test where id = ?";
    public static final String CUSTOM_TYPE_NAME = "CUSTOM_TYPE_NAME";
    private final DbTypeManager dbTypeManager = (DbTypeManager)Mockito.mock(DbTypeManager.class);
    private final ParamTypeResolver metadataParamTypeResolver = (ParamTypeResolver)Mockito.mock(ParamTypeResolver.class);
    private final DefaultParamTypeResolver paramTypeResolver = new DefaultParamTypeResolver(this.dbTypeManager, this.metadataParamTypeResolver);
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);

    @Test
    public void resolvesUnknownTypeUsingMetadata() throws Exception {
        QueryTemplate queryTemplate = new QueryTemplate(SQL_TEXT, QueryType.SELECT, Collections.singletonList(new DefaultInputQueryParam(1, UnknownDbType.getInstance(), (Object)"7", "param1")));
        Mockito.when((Object)this.metadataParamTypeResolver.getParameterTypes(this.connection, queryTemplate)).thenReturn(Collections.singletonMap(1, JdbcTypes.INTEGER_DB_TYPE));
        Map parameterTypes = this.paramTypeResolver.getParameterTypes(this.connection, queryTemplate);
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)parameterTypes.size()));
        Assert.assertThat((Object)JdbcTypes.INTEGER_DB_TYPE, (Matcher)CoreMatchers.equalTo(parameterTypes.get(1)));
    }

    @Test
    public void requestsMetadataOnce() throws Exception {
        DefaultInputQueryParam param1 = new DefaultInputQueryParam(1, UnknownDbType.getInstance(), (Object)"7", "param1");
        DefaultInputQueryParam param2 = new DefaultInputQueryParam(2, UnknownDbType.getInstance(), (Object)"A", "param2");
        ArrayList<DefaultInputQueryParam> params = new ArrayList<DefaultInputQueryParam>();
        params.add(param1);
        params.add(param2);
        QueryTemplate queryTemplate = new QueryTemplate(SQL_TEXT, QueryType.SELECT, params);
        HashMap<Integer, DbType> paramTypes = new HashMap<Integer, DbType>();
        paramTypes.put(1, JdbcTypes.INTEGER_DB_TYPE);
        paramTypes.put(2, JdbcTypes.INTEGER_DB_TYPE);
        Mockito.when((Object)this.metadataParamTypeResolver.getParameterTypes(this.connection, queryTemplate)).thenReturn(paramTypes);
        this.paramTypeResolver.getParameterTypes(this.connection, queryTemplate);
        ((ParamTypeResolver)Mockito.verify((Object)this.metadataParamTypeResolver, (VerificationMode)Mockito.times((int)1))).getParameterTypes(this.connection, queryTemplate);
    }

    @Test
    public void usesUnknownTypesWhenNoMetadataAvailable() throws Exception {
        QueryTemplate queryTemplate = new QueryTemplate(SQL_TEXT, QueryType.SELECT, Collections.singletonList(new DefaultInputQueryParam(1, UnknownDbType.getInstance(), (Object)"7", "param1")));
        Mockito.when((Object)this.metadataParamTypeResolver.getParameterTypes(this.connection, queryTemplate)).thenThrow(new Throwable[]{new SQLException("Error")});
        Map parameterTypes = this.paramTypeResolver.getParameterTypes(this.connection, queryTemplate);
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)parameterTypes.size()));
        Assert.assertThat((Object)UnknownDbType.getInstance(), (Matcher)CoreMatchers.equalTo(parameterTypes.get(1)));
    }

    @Test
    public void resolvesDynamicDbType() throws Exception {
        QueryTemplate queryTemplate = new QueryTemplate(SQL_TEXT, QueryType.SELECT, Collections.singletonList(new DefaultInputQueryParam(1, (DbType)new DynamicDbType(CUSTOM_TYPE_NAME), (Object)"7", "param1")));
        DbType customType = (DbType)Mockito.mock(DbType.class);
        Mockito.when((Object)this.dbTypeManager.lookup(this.connection, CUSTOM_TYPE_NAME)).thenReturn((Object)customType);
        Map parameterTypes = this.paramTypeResolver.getParameterTypes(this.connection, queryTemplate);
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)parameterTypes.size()));
        Assert.assertThat((Object)customType, (Matcher)CoreMatchers.equalTo(parameterTypes.get(1)));
        ((ParamTypeResolver)Mockito.verify((Object)this.metadataParamTypeResolver, (VerificationMode)Mockito.never())).getParameterTypes(this.connection, queryTemplate);
    }

    @Test
    public void skipsResolvedTypes() throws Exception {
        QueryTemplate queryTemplate = new QueryTemplate(SQL_TEXT, QueryType.SELECT, Collections.singletonList(new DefaultInputQueryParam(1, JdbcTypes.INTEGER_DB_TYPE, (Object)"7", "param1")));
        Map parameterTypes = this.paramTypeResolver.getParameterTypes(this.connection, queryTemplate);
        Assert.assertThat((Object)1, (Matcher)CoreMatchers.equalTo((Object)parameterTypes.size()));
        Assert.assertThat((Object)JdbcTypes.INTEGER_DB_TYPE, (Matcher)CoreMatchers.equalTo(parameterTypes.get(1)));
        ((ParamTypeResolver)Mockito.verify((Object)this.metadataParamTypeResolver, (VerificationMode)Mockito.never())).getParameterTypes(this.connection, queryTemplate);
    }

    @Test(expected=UnknownDbTypeException.class)
    public void failsResolvingInvalidType() throws Exception {
        QueryTemplate queryTemplate = new QueryTemplate(SQL_TEXT, QueryType.SELECT, Collections.singletonList(new DefaultInputQueryParam(1, (DbType)new DynamicDbType(CUSTOM_TYPE_NAME), (Object)"7", "param1")));
        Mockito.when((Object)this.metadataParamTypeResolver.getParameterTypes(this.connection, queryTemplate)).thenThrow(new Throwable[]{new SQLException("Error")});
        Mockito.when((Object)this.dbTypeManager.lookup(this.connection, CUSTOM_TYPE_NAME)).thenThrow(new Throwable[]{new UnknownDbTypeException(CUSTOM_TYPE_NAME)});
        this.paramTypeResolver.getParameterTypes(this.connection, queryTemplate);
    }
}

