/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.performance;

import org.junit.Ignore;
import org.junit.Test;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.performance.LoadGenerator;
import org.mule.module.db.performance.LoadTask;
import org.mule.tck.junit4.FunctionalTestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class QueryPerformanceTestCase
extends FunctionalTestCase {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryPerformanceTestCase.class);
    private LoadGenerator loadGenerator = new LoadGenerator();

    protected String getConfigFile() {
        return "integration/derby-datasource.xml,integration/select/default-select-config.xml";
    }

    public int getTestTimeoutSecs() {
        return 300;
    }

    @Test
    public void testRequestResponsePerformance() throws Exception {
        this.loadGenerator.generateLoad(new RequestResponseLoadTask());
        this.takeANap();
    }

    @Test
    public void testOneWayPerformance() throws Exception {
        Thread outputCleaner = new Thread(new LoadCleaner());
        outputCleaner.start();
        this.loadGenerator.generateLoad(new OneWayLoadTask());
        this.takeANap();
        outputCleaner.interrupt();
    }

    private void takeANap() throws InterruptedException {
        Thread.sleep(120000L);
    }

    private class OneWayLoadTask
    implements LoadTask {
        private OneWayLoadTask() {
        }

        @Override
        public void execute(int messageId) throws Exception {
            LOGGER.info("Thread: " + Thread.currentThread().getName() + " message: " + messageId);
            LocalMuleClient client = muleContext.getClient();
            client.dispatch("vm://testOneWay", (Object)"Test Message", null);
        }
    }

    private class RequestResponseLoadTask
    implements LoadTask {
        private RequestResponseLoadTask() {
        }

        @Override
        public void execute(int messageId) throws Exception {
            LOGGER.info("Thread: " + Thread.currentThread().getName() + " message: " + messageId);
            LocalMuleClient client = muleContext.getClient();
            client.send("vm://testRequestResponse", (Object)"Test Message", null);
        }
    }

    private static class LoadCleaner
    implements Runnable {
        private LoadCleaner() {
        }

        @Override
        public void run() {
            LocalMuleClient client = muleContext.getClient();
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    client.request("vm://testOut", 5000L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

