/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.context.WorkManager;
import org.mule.api.registry.MuleRegistry;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.database.GenericDbConfigFactory;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.retry.policies.NoRetryPolicyTemplate;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class GenericDbConfigFactoryTestCase
extends AbstractMuleTestCase {
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final GenericDbConfigFactory genericDbConfigFactory = new GenericDbConfigFactory();
    private final Map<QName, Object> annotations = (Map)Mockito.mock(Map.class);
    private final DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
    private final List<DbType> customDataTypes = new ArrayList<DbType>();
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    private final MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
    private final RetryPolicyTemplate globalRetryPolicyTemplate = (RetryPolicyTemplate)Mockito.mock(RetryPolicyTemplate.class);
    private final NoRetryPolicyTemplate noRetryPolicyTemplate = (NoRetryPolicyTemplate)Mockito.mock(NoRetryPolicyTemplate.class);
    private final RetryPolicyTemplate specificRetryPolicyTemplate = (RetryPolicyTemplate)Mockito.mock(RetryPolicyTemplate.class);
    private DbConfig dbConfig = null;
    private DbConnectionFactory dbConnectionFactory = null;

    @Before
    public void setUp() throws Exception {
        this.genericDbConfigFactory.setMuleContext(this.muleContext);
        this.genericDbConfigFactory.setCustomDataTypes(this.customDataTypes);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)this.muleRegistry);
        Mockito.when((Object)this.globalRetryPolicyTemplate.isSynchronous()).thenReturn((Object)true);
        Mockito.when((Object)this.specificRetryPolicyTemplate.isSynchronous()).thenReturn((Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnlyExistsGlobalRetryPolicyTemplate() throws Exception {
        this.expectedException.expect(SQLException.class);
        Mockito.when((Object)this.muleRegistry.lookupObject("_defaultRetryPolicyTemplate")).thenReturn((Object)this.globalRetryPolicyTemplate);
        this.dbConfig = this.genericDbConfigFactory.create("name", this.annotations, this.dataSource);
        this.dbConnectionFactory = this.dbConfig.getConnectionFactory();
        try {
            this.dbConnectionFactory.createConnection(TransactionalAction.JOIN_IF_POSSIBLE);
        }
        finally {
            ((RetryPolicyTemplate)Mockito.verify((Object)this.globalRetryPolicyTemplate)).execute((RetryCallback)Matchers.any(RetryCallback.class), (WorkManager)Matchers.any(WorkManager.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOnlyExistsSpecificRetryPolicyTemplate() throws Exception {
        this.expectedException.expect(SQLException.class);
        this.genericDbConfigFactory.setRetryPolicyTemplate(this.specificRetryPolicyTemplate);
        this.dbConfig = this.genericDbConfigFactory.create("name", this.annotations, this.dataSource);
        this.dbConnectionFactory = this.dbConfig.getConnectionFactory();
        try {
            this.dbConnectionFactory.createConnection(TransactionalAction.JOIN_IF_POSSIBLE);
        }
        finally {
            ((RetryPolicyTemplate)Mockito.verify((Object)this.specificRetryPolicyTemplate)).execute((RetryCallback)Matchers.any(RetryCallback.class), (WorkManager)Matchers.any(WorkManager.class));
        }
    }

    @Test
    public void testNotExistGlobalRetryPolicyTemplate() throws Exception {
        Mockito.when((Object)this.muleRegistry.lookupObject("_defaultRetryPolicyTemplate")).thenReturn((Object)this.noRetryPolicyTemplate);
        Assert.assertThat((Object)this.genericDbConfigFactory.getDefaultRetryPolicyTemplate(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExistsBothRetryPolicyTemplates() throws Exception {
        this.expectedException.expect(SQLException.class);
        this.genericDbConfigFactory.setRetryPolicyTemplate(this.specificRetryPolicyTemplate);
        Mockito.when((Object)this.muleRegistry.lookupObject("_defaultRetryPolicyTemplate")).thenReturn((Object)this.globalRetryPolicyTemplate);
        this.dbConfig = this.genericDbConfigFactory.create("name", this.annotations, this.dataSource);
        this.dbConnectionFactory = this.dbConfig.getConnectionFactory();
        try {
            this.dbConnectionFactory.createConnection(TransactionalAction.JOIN_IF_POSSIBLE);
        }
        finally {
            ((RetryPolicyTemplate)Mockito.verify((Object)this.specificRetryPolicyTemplate)).execute((RetryCallback)Matchers.any(RetryCallback.class), (WorkManager)Matchers.any(WorkManager.class));
        }
    }
}

