/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.xa;

import java.util.Collections;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.integration.model.Record;
import org.mule.transport.NullPayload;

public abstract class AbstractXaTransactionalTestCase
extends AbstractDbIntegrationTestCase {
    public AbstractXaTransactionalTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Collections.singletonList(new Object[]{"integration/config/derby-xa-db-config.xml", new DerbyTestDatabase()});
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{this.getTransactionManagerResource(), "integration/xa/xa-transactional-config.xml"};
    }

    protected abstract String getTransactionManagerResource();

    @Test
    public void commitsChanges() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testCommit", (Object)"Test Message", null);
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }

    @Test
    public void rollbacksChanges() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testRollback", (Object)"Test Message", null);
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", Planet.MARS.getName()), new Field("POSITION", 4)));
    }

    @Test
    public void commitsChangesWhenMpIsNotTransactionalOnRollback() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://rollbackWithNonTransactionalMP", (Object)"Test Message", null);
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }

    @Test
    public void commitsChangesWhenMpIsNotTransactionalOnCommit() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://commitWithNonTransactionalMP", (Object)"Test Message", null);
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }
}

