/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.query;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.expression.ExpressionManager;
import org.mule.module.db.internal.domain.query.BulkQuery;
import org.mule.module.db.internal.parser.QueryTemplateParser;
import org.mule.module.db.internal.resolver.query.AbstractBulkQueryResolverTestCase;
import org.mule.module.db.internal.resolver.query.DynamicBulkQueryResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DynamicBulkQueryResolverTestCase
extends AbstractBulkQueryResolverTestCase {
    public static final String DYNAMIC_BULK_QUERY = "#[bulkQuery]";

    @Test
    public void doesNotResolvesBulkQueryWhenThereIsNoEvent() throws Exception {
        DynamicBulkQueryResolver bulkQueryResolver = new DynamicBulkQueryResolver(DYNAMIC_BULK_QUERY, null, null);
        BulkQuery resolvedBulkQuery = bulkQueryResolver.resolve(null);
        Assert.assertThat((Object)resolvedBulkQuery, (Matcher)CoreMatchers.nullValue());
    }

    @Test(expected=QueryResolutionException.class)
    public void throwsErrorOnEmptyBulkQuery() throws Exception {
        QueryTemplateParser queryTemplateParser = this.createQueryTemplateParser();
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        Mockito.when((Object)expressionManager.parse(DYNAMIC_BULK_QUERY, this.muleEvent)).thenReturn((Object)"");
        DynamicBulkQueryResolver bulkQueryResolver = new DynamicBulkQueryResolver(DYNAMIC_BULK_QUERY, queryTemplateParser, expressionManager);
        bulkQueryResolver.resolve(this.muleEvent);
    }

    @Test
    public void resolvesDynamicBulkQuery() throws Exception {
        QueryTemplateParser queryTemplateParser = this.createQueryTemplateParser();
        ExpressionManager expressionManager = (ExpressionManager)Mockito.mock(ExpressionManager.class);
        Mockito.when((Object)expressionManager.parse(DYNAMIC_BULK_QUERY, this.muleEvent)).thenReturn((Object)"delete from test1;\ndelete from test2");
        DynamicBulkQueryResolver bulkQueryResolver = new DynamicBulkQueryResolver(DYNAMIC_BULK_QUERY, queryTemplateParser, expressionManager);
        BulkQuery resolvedBulkQuery = bulkQueryResolver.resolve(this.muleEvent);
        this.assertResolvedBulkQuery(resolvedBulkQuery);
    }
}

