/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;

public abstract class AbstractStoredProcedureParameterizedUpdateTestCase
extends AbstractDbIntegrationTestCase {
    public AbstractStoredProcedureParameterizedUpdateTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Test
    public void testRequestResponse() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testRequestResponse", (Object)"foo", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(Map.class)));
        Map payload = (Map)response.getPayload();
        Assert.assertThat((Object)payload.size(), (Matcher)IsEqual.equalTo((Object)1));
        int expectedUpdateCount = this.testDatabase instanceof DerbyTestDatabase ? 0 : 1;
        Assert.assertThat((Object)((Integer)payload.get("updateCount1")), (Matcher)IsEqual.equalTo((Object)expectedUpdateCount));
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "foo"), new Field("POSITION", 4)));
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        this.testDatabase.createStoredProcedureParameterizedUpdateTestType1(this.getDefaultDataSource());
    }
}

