/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.el;

import java.sql.Array;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.el.AbstractDbCreateFunctionTestCase;
import org.mule.module.db.internal.el.AbstractDbFunction;
import org.mule.module.db.internal.el.DbCreateArrayFunction;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DbCreateArrayFunctionTestCase
extends AbstractDbCreateFunctionTestCase {
    @Test
    public void createsDbArrayFromJavaArray() throws Exception {
        Object[] structValue = new Object[]{"foo", "bar"};
        Object[] params = new Object[]{"dbConfig", "TEST_ARRAY", structValue};
        DbConnection dbConnection = this.createDbConnection(true);
        Array array = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)dbConnection.createArrayOf("TEST_ARRAY", structValue)).thenReturn((Object)array);
        Object result = this.function.call(params, this.context);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)array));
    }

    @Test
    public void createsDbArrayFromList() throws Exception {
        Object[] structValues = new Object[]{"foo", "bar"};
        Object[] params = new Object[]{"dbConfig", "TEST_ARRAY", Arrays.asList(structValues)};
        DbConnection dbConnection = this.createDbConnection(true);
        Array array = (Array)Mockito.mock(Array.class);
        Mockito.when((Object)dbConnection.createArrayOf("TEST_ARRAY", structValues)).thenReturn((Object)array);
        Object result = this.function.call(params, this.context);
        MatcherAssert.assertThat((Object)result, (Matcher)Matchers.equalTo((Object)array));
    }

    @Override
    protected AbstractDbFunction createDbFunction(MuleContext muleContext) {
        return new DbCreateArrayFunction(muleContext);
    }
}

