/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.internal.domain.param.DefaultInputQueryParam;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;
import org.mule.module.db.internal.processor.AbstractSingleQueryMessageProcessorDebugInfoTestCase;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;

public abstract class AbstractParameterizedSingleQueryMessageProcessorDebugInfoTestCase
extends AbstractSingleQueryMessageProcessorDebugInfoTestCase {
    public static final String NAME_PARAM = "name";
    public static final String POSITION_PARAM = "position";
    public static final String PARAM1 = "param 1";
    public static final String PARAM2 = "param 2";

    @Test
    public void returnsDebugInfoWithNamedParameters() throws Exception {
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        Mockito.when((Object)this.queryResolver.resolve(this.connection, this.event)).thenReturn((Object)this.createQueryWithNamedParameters());
        AbstractSingleQueryDbMessageProcessor processor = this.createMessageProcessor();
        List debugInfo = processor.getDebugInfo(this.event);
        this.assertQueryDebugInfo(debugInfo, NAME_PARAM, POSITION_PARAM);
    }

    @Test
    public void returnsDebugInfoWithInlinedParameters() throws Exception {
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        Mockito.when((Object)this.queryResolver.resolve(this.connection, this.event)).thenReturn((Object)this.createQueryWithInlinedParams());
        AbstractSingleQueryDbMessageProcessor processor = this.createMessageProcessor();
        List debugInfo = processor.getDebugInfo(this.event);
        this.assertQueryDebugInfo(debugInfo, PARAM1, PARAM2);
    }

    protected void assertQueryDebugInfo(List<FieldDebugInfo<?>> debugInfo, String paramName1, String paramName2) {
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat(debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"SQL", String.class, (Object)this.getSqlText())));
        MatcherAssert.assertThat(debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Type", String.class, (Object)this.getQueryType().toString())));
        ArrayList<Matcher> paramMatchers = new ArrayList<Matcher>();
        paramMatchers.add(FieldDebugInfoMatcher.fieldLike((String)paramName1, String.class, (Object)Planet.EARTH.getName()));
        paramMatchers.add(FieldDebugInfoMatcher.fieldLike((String)paramName2, String.class, (Object)Planet.EARTH.getPosition()));
        MatcherAssert.assertThat(debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Input params", List.class, paramMatchers)));
    }

    protected Query createQueryWithNamedParameters() {
        ArrayList<DefaultInputQueryParam> params = new ArrayList<DefaultInputQueryParam>();
        params.add(new DefaultInputQueryParam(1, null, (Object)Planet.EARTH.getName(), NAME_PARAM));
        params.add(new DefaultInputQueryParam(2, null, (Object)Planet.EARTH.getPosition(), POSITION_PARAM));
        QueryTemplate queryTemplate = new QueryTemplate(this.getSqlText(), this.getQueryType(), params);
        return new Query(queryTemplate);
    }

    protected Query createQueryWithInlinedParams() {
        ArrayList<DefaultInputQueryParam> params = new ArrayList<DefaultInputQueryParam>();
        params.add(new DefaultInputQueryParam(1, null, (Object)Planet.EARTH.getName(), null));
        params.add(new DefaultInputQueryParam(2, null, (Object)Planet.EARTH.getPosition(), null));
        QueryTemplate queryTemplate = new QueryTemplate(this.getSqlText(), this.getQueryType(), params);
        return new Query(queryTemplate);
    }
}

