/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.bulkexecute;

import java.sql.SQLException;
import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.bulkexecute.AbstractBulkExecuteTestCase;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.tck.junit4.rule.SystemProperty;

public class BulkExecutePlaceholderTestCase
extends AbstractBulkExecuteTestCase {
    @Rule
    public SystemProperty bulkQuery = new SystemProperty("bulkQuery", "update PLANET set NAME='Mercury' where POSITION=0;\nupdate PLANET set NAME='Mercury' where POSITION=4");
    @Rule
    public SystemProperty file = new SystemProperty("file", "integration/bulkexecute/bulk-execute.sql");

    public BulkExecutePlaceholderTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/bulkexecute/bulk-execute-placeholder-config.xml"};
    }

    @Test
    public void resolvesBulkQueryPlaceholder() throws Exception {
        this.doTest("vm://bulkUpdatePlaceholder");
    }

    @Test
    public void resolvesFilePlaceholder() throws Exception {
        this.doTest("vm://bulkUpdateFilePlaceholder");
    }

    private void doTest(String url) throws MuleException, SQLException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send(url, (Object)"Test Message", null);
        this.assertBulkModeResult(response.getPayload());
    }
}

