/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.function;

import java.sql.Struct;
import java.util.LinkedList;
import java.util.List;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.function.AbstractDbFunctionTestCase;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Contact;
import org.mule.module.db.integration.model.OracleTestDatabase;
import org.mule.module.db.integration.model.Region;

public class DbCreateArrayFunctionTestCase
extends AbstractDbFunctionTestCase {
    public DbCreateArrayFunctionTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        if (!TestDbConfig.getOracleResource().isEmpty()) {
            params.add(new Object[]{"integration/config/oracle-unmapped-udt-db-config.xml", new OracleTestDatabase()});
        }
        return params;
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/function/create-array-udt-config.xml"};
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        DataSource dataSource = this.getDefaultDataSource();
        this.testDatabase.createStoredProcedureGetZipCodes(dataSource);
        this.testDatabase.createStoredProcedureGetContactDetails(dataSource);
        this.testDatabase.createStoredProcedureUpdateZipCodes(dataSource);
        this.testDatabase.createStoredProcedureUpdateContactDetails(dataSource);
    }

    @Test
    public void createsDefaultTypeArray() throws Exception {
        MuleEvent response = this.runFlow("createsDefaultTypeArray", Region.NORTHWEST.getZips());
        MatcherAssert.assertThat((Object)response.getMessage().getPayload(), (Matcher)Matchers.equalTo((Object)Region.NORTHWEST.getZips()));
    }

    @Test
    public void createsCustomTypeArray() throws Exception {
        MuleEvent response = this.runFlow("createsCustomTypeArray", Contact.CONTACT2.getDetails());
        Object[] arrayValue = (Object[])response.getMessage().getPayload();
        MatcherAssert.assertThat((Object)arrayValue.length, (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)arrayValue[0], (Matcher)Matchers.instanceOf(Struct.class));
        Object[] attributes = ((Struct)arrayValue[0]).getAttributes();
        MatcherAssert.assertThat((Object)attributes, (Matcher)Matchers.equalTo((Object)Contact.CONTACT2.getDetailsAsObjectArray()[0]));
    }
}

