/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.insert;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.AnyOf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.transport.NullPayload;

public class InsertBulkTestCase
extends AbstractDbIntegrationTestCase {
    public InsertBulkTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/insert/insert-bulk-config.xml"};
    }

    @Test
    public void insertsInBulkMode() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add("Pluto");
        planetNames.add("Saturn");
        MuleMessage response = client.send("vm://insertBulk", planetNames, null);
        this.assertBulkInsert(response.getPayload());
    }

    @Test
    public void requiresCollectionPayload() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://insertBulk", (Object)"Test Message", null);
        Assert.assertTrue((boolean)(response.getPayload() instanceof NullPayload));
        Assert.assertNotNull((Object)response.getExceptionPayload());
    }

    private void assertBulkInsert(Object payload) throws SQLException {
        Assert.assertTrue((boolean)(payload instanceof int[]));
        int[] counters = (int[])payload;
        Assert.assertEquals((long)2L, (long)counters.length);
        Assert.assertThat((Object)counters[0], (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.equalTo((Object)1), (Matcher)CoreMatchers.equalTo((Object)-2)));
        Assert.assertThat((Object)counters[1], (Matcher)AnyOf.anyOf((Matcher)CoreMatchers.equalTo((Object)1), (Matcher)CoreMatchers.equalTo((Object)-2)));
        this.assertPlanetRecordsFromQuery("Pluto", "Saturn");
    }
}

