/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;

public class SelectDynamicQueryDebugInfoTestCase
extends AbstractDbIntegrationTestCase {
    public SelectDynamicQueryDebugInfoTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-dynamic-query-config.xml"};
    }

    @Test
    public void providesDebugInfo() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("selectDynamicQuery");
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractSingleQueryDbMessageProcessor queryMessageProcessor = (AbstractSingleQueryDbMessageProcessor)messageProcessors.get(1);
        MuleEvent muleEvent = SelectDynamicQueryDebugInfoTestCase.getTestEvent((Object)"Test Message");
        muleEvent.getMessage().setInvocationProperty("tableName", (Object)"PLANET");
        List debugInfo = queryMessageProcessor.getDebugInfo(muleEvent);
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"SQL", String.class, (Object)"select * from PLANET order by ID")));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Type", String.class, (Object)"SELECT")));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Input params", List.class, (Matcher)Matchers.empty())));
    }
}

