/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.debug.ObjectFieldDebugInfo;
import org.mule.api.debug.SimpleFieldDebugInfo;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;
import org.mule.module.db.internal.processor.SelectMessageProcessor;

public class SelectNullParamTestCase
extends AbstractDbIntegrationTestCase {
    public SelectNullParamTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-null-param-config.xml"};
    }

    @Test
    public void testOverrideParamWithNullValue() throws Exception {
        SimpleFieldDebugInfo paramInfo = this.getParams("overrideParamWithNullValue").get(0);
        Assert.assertThat((Object)paramInfo.getName(), (Matcher)CoreMatchers.is((Object)"position"));
        Assert.assertThat((Object)paramInfo.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void testImplicitParamWithNullValue() throws Exception {
        SimpleFieldDebugInfo paramInfo = this.getParams("implicitNullValue").get(0);
        Assert.assertThat((Object)paramInfo.getName(), (Matcher)CoreMatchers.is((Object)"position"));
        Assert.assertThat((Object)paramInfo.getValue(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    private List<SimpleFieldDebugInfo> getParams(String flowName) {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
        List messageProcessors = flowConstruct.getMessageProcessors();
        Assert.assertThat(messageProcessors.get(0), (Matcher)CoreMatchers.instanceOf(SelectMessageProcessor.class));
        AbstractDbMessageProcessor selectMessageProcessor = (AbstractDbMessageProcessor)messageProcessors.get(0);
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        List debugInfo = selectMessageProcessor.getDebugInfo(event);
        ObjectFieldDebugInfo paramsInfo = (ObjectFieldDebugInfo)debugInfo.get(2);
        return (List)paramsInfo.getValue();
    }
}

