/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractSingleQueryDbMessageProcessor;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;

public class SelectParameterizedQueryDebugInfoTestCase
extends AbstractDbIntegrationTestCase {
    public static final String PARAM1 = "param 1";

    public SelectParameterizedQueryDebugInfoTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/inline-parameterized-query-config.xml"};
    }

    @Test
    public void providesDebugInfo() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("expressionParam");
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractSingleQueryDbMessageProcessor queryMessageProcessor = (AbstractSingleQueryDbMessageProcessor)messageProcessors.get(1);
        MuleEvent muleEvent = SelectParameterizedQueryDebugInfoTestCase.getTestEvent((Object)"Test Message");
        String expectedPosition = "3";
        muleEvent.getMessage().setInvocationProperty("position", (Object)"3");
        List debugInfo = queryMessageProcessor.getDebugInfo(muleEvent);
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"SQL", String.class, (Object)"SELECT * FROM PLANET WHERE POSITION = ? AND NAME = 'Earth'")));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Type", String.class, (Object)"SELECT")));
        ArrayList<Matcher> paramMatchers = new ArrayList<Matcher>();
        paramMatchers.add(FieldDebugInfoMatcher.fieldLike((String)PARAM1, String.class, (Object)"3"));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Input params", List.class, paramMatchers)));
    }
}

