/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.result.resultset.ResultSetIterator;
import org.mule.transport.NullPayload;

public class SelectStreamingResourceManagementTestCase
extends AbstractDbIntegrationTestCase {
    public SelectStreamingResourceManagementTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/config/derby-pooling-db-config.xml", "integration/select/select-streaming-resource-management-config.xml"};
    }

    @Test
    public void closesConnectionsWhenResultSetConsumed() throws Exception {
        this.doSuccessfulTestMessage();
        this.doSuccessfulTestMessage();
        this.doSuccessfulTestMessage();
    }

    private void doSuccessfulTestMessage() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://selectStreaming", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(ResultSetIterator.class)));
        TestRecordUtil.assertRecords(response.getInboundProperty("processedRecords"), TestRecordUtil.getAllPlanetRecords());
    }

    @Test
    public void closesConnectionsOnProcessingError() throws Exception {
        this.doFailedMessageTest();
        this.doFailedMessageTest();
        this.doFailedMessageTest();
    }

    private void doFailedMessageTest() throws MuleException {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://selectStreamingError", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)response.getExceptionPayload().getRootException().getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Failing test on purpose"));
        Assert.assertThat((Object)response.getPayload(), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(NullPayload.class)));
    }
}

