/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.integration.model.Record;

public class SelectWithAliasTestCase
extends AbstractDbIntegrationTestCase {
    public static final String NAME_FIELD_ALIAS = "PLANETNAME";

    public SelectWithAliasTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-with-alias-config.xml"};
    }

    @Test
    public void returnsAliasInResultSet() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://usesAlias", (Object)"Test Message", null);
        TestRecordUtil.assertMessageContains(response, this.getExpectedRecords());
    }

    public Record[] getExpectedRecords() {
        return new Record[]{new Record(new Field(NAME_FIELD_ALIAS, Planet.VENUS.getName())), new Record(new Field(NAME_FIELD_ALIAS, Planet.EARTH.getName())), new Record(new Field(NAME_FIELD_ALIAS, Planet.MARS.getName()))};
    }
}

