/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.util.List;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.matcher.SupportsReturningStoredProcedureResultsWithoutParameters;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;

public class StoredProcedureSourceTestCase
extends AbstractDbIntegrationTestCase {
    public StoredProcedureSourceTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/storedprocedure/stored-procedure-source-config.xml"};
    }

    @Test
    public void usesCustomSource() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://storedProcedureCustomSource", (Object)"Test Message", null);
        Assert.assertThat((Object)response.getPayload(), (Matcher)CoreMatchers.is((Matcher)IsInstanceOf.instanceOf(Map.class)));
        Map payload = (Map)response.getPayload();
        Assert.assertThat((Object)payload.size(), (Matcher)IsEqual.equalTo((Object)1));
        int expectedUpdateCount = this.testDatabase instanceof DerbyTestDatabase ? 0 : 1;
        Assert.assertThat((Object)((Integer)payload.get("updateCount1")), (Matcher)IsEqual.equalTo((Object)expectedUpdateCount));
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Pluto"), new Field("POSITION", 4)));
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        Assume.assumeThat((Object)this.getDefaultDataSource(), (Matcher)new SupportsReturningStoredProcedureResultsWithoutParameters());
        this.testDatabase.createStoredProcedureParameterizedUpdateTestType1(this.getDefaultDataSource());
    }
}

