/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.storedprocedure;

import java.sql.Struct;
import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Contact;
import org.mule.module.db.integration.model.OracleTestDatabase;

public class StoredProcedureStructArrayUdtTestCase
extends AbstractDbIntegrationTestCase {
    public StoredProcedureStructArrayUdtTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        if (!TestDbConfig.getOracleResource().isEmpty()) {
            params.add(new Object[]{"integration/config/oracle-unmapped-udt-db-config.xml", new OracleTestDatabase()});
        }
        return params;
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/storedprocedure/stored-procedure-udt-array-config.xml"};
    }

    @Before
    public void setupStoredProcedure() throws Exception {
        this.testDatabase.createStoredProcedureGetContactDetails(this.getDefaultDataSource());
    }

    @Test
    public void returnsCustomArray() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://returnsCustomArrayValue", (Object)"Test Message", null);
        MatcherAssert.assertThat((Object)response.getPayload(), (Matcher)Matchers.instanceOf(Object[].class));
        Object[] arrayPayload = (Object[])response.getPayload();
        MatcherAssert.assertThat((Object)arrayPayload.length, (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)arrayPayload[0], (Matcher)Matchers.instanceOf(Struct.class));
        MatcherAssert.assertThat((Object)((Struct)arrayPayload[0]).getAttributes(), (Matcher)Matchers.equalTo((Object)Contact.CONTACT1.getDetailsAsObjectArray()[0]));
    }
}

