/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.sql.SQLException;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;

public class MergeTestCase
extends AbstractDbIntegrationTestCase {
    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    public MergeTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/merge-config.xml"};
    }

    @Test
    public void mergesTables() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://merge", (Object)"Test Message", null);
        this.assertMergeResult(response);
    }

    private void assertMergeResult(MuleMessage response) throws SQLException {
        Assert.assertThat((Object)((Integer)response.getPayload()), (Matcher)CoreMatchers.equalTo((Object)3));
        List result = DbTestUtil.selectData("select * from PLANET order by ID", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, this.createRecord(2), this.createRecord(3), this.createRecord(4));
    }

    private Record createRecord(int pos) {
        return new Record(new Field("NAME", "merged"), new Field("POSITION", pos));
    }
}

