/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.common.Result;
import org.mule.construct.Flow;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.delete.AbstractBulkUpdateInputMetadataTestCase;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;

public class UpdateBulkInputMetadataTestCase
extends AbstractBulkUpdateInputMetadataTestCase {
    public UpdateBulkInputMetadataTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/update-bulk-input-metadata-config.xml"};
    }

    @Test
    public void returnsNullUpdateMetadataUnParameterizedQuery() throws Exception {
        this.doUnresolvedMetadataTest("updateBulkMetadataNoParams");
    }

    @Test
    public void returnsNullUpdateInputMetadataFromNotSupportedParameterizedQuery() throws Exception {
        this.doUnresolvedMetadataTest("updateBulkMetadataNotSupportedValueParams");
    }

    @Test
    public void returnsUpdateInputMetadataFromBeanParameterizedQuery() throws Exception {
        this.doResolvedMetadataTest("updateBulkMetadataBeanParams");
    }

    @Test
    public void returnsUpdateInputMetadataFromMapParameterizedQuery() throws Exception {
        this.doResolvedMetadataTest("updateBulkMetadataMapParams");
    }

    private void doUnresolvedMetadataTest(String flowName) {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct(flowName);
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractDbMessageProcessor queryMessageProcessor = (AbstractDbMessageProcessor)messageProcessors.get(0);
        Result inputMetaData = queryMessageProcessor.getInputMetaData();
        Assert.assertThat((Object)inputMetaData, (Matcher)CoreMatchers.equalTo(null));
    }
}

