/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;

public class UpdateNameParamOverrideTestCase
extends AbstractDbIntegrationTestCase {
    public UpdateNameParamOverrideTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/update-name-param-override-config.xml"};
    }

    @Test
    public void usesDefaultParams() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://defaultParams", (Object)"Test Message", null);
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }

    @Test
    public void usesOverriddenParams() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://overriddenParams", (Object)"Test Message", null);
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=2", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 2)));
    }

    public void usesInlineOverriddenParams() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://inlineOverriddenParams", (Object)"Test Message", null);
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=3", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 3)));
    }

    @Test
    public void usesParamsInInlineQuery() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://inlineQuery", (Object)"Test Message", null);
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=4", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 4)));
    }

    @Test
    public void usesExpressionParam() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        HashMap<String, Integer> props = new HashMap<String, Integer>();
        props.put("type", 3);
        MuleMessage response = client.send("vm://expressionParam", (Object)"Test Message", props);
        Assert.assertEquals((Object)1, (Object)response.getPayload());
        List result = DbTestUtil.selectData("select * from PLANET where POSITION=3", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", "Mercury"), new Field("POSITION", 3)));
    }
}

