/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.vendor.oracle;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNull;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Alien;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;
import org.mule.module.db.integration.vendor.oracle.AbstractOracleXmlTypeTestCase;
import org.mule.module.db.internal.domain.type.oracle.OracleXmlType;
import org.mule.util.IOUtils;

public class OracleInsertXmlTypeTestCase
extends AbstractOracleXmlTypeTestCase {
    public OracleInsertXmlTypeTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getOracleResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/vendor/oracle/oracle-insert-xml-type-config.xml"};
    }

    @Test
    public void insertXmlTypeFromXmlType() throws Exception {
        this.assertAlienWasInserted(this.doTest(new XmlContentBuilder(){

            @Override
            public Object build(Connection connection) throws Exception {
                return OracleXmlType.createXmlType((Connection)connection, (String)Alien.ET.getXml());
            }
        }));
    }

    @Test
    public void insertLargeXmlTypeFromInputStream() throws Exception {
        this.assertAlienWasInserted(this.doTest(new XmlContentBuilder(){

            @Override
            public Object build(Connection connection) throws Exception {
                return IOUtils.getResourceAsStream((String)"integration/vendor/oracle/oracle-insert-xml-type-large-sample.xml", this.getClass());
            }
        }));
    }

    @Test
    public void insertXmlTypeFromString() throws Exception {
        this.assertAlienWasInserted(this.doTest(new XmlContentBuilder(){

            @Override
            public Object build(Connection connection) throws Exception {
                return Alien.ET.getXml();
            }
        }));
    }

    @Test
    public void insertXmlTypeFromWrongType() throws Exception {
        this.assertNoAliens(this.doTest(new XmlContentBuilder(){

            @Override
            public Object build(Connection connection) throws Exception {
                return new Integer(1);
            }
        }));
    }

    private void assertNoAliens(MuleMessage response) throws SQLException {
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)Is.is((Matcher)IsNull.notNullValue()));
        List result = DbTestUtil.selectData("SELECT name FROM Alien", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record[0]);
    }

    private void assertAlienWasInserted(MuleMessage response) throws SQLException {
        Assert.assertThat((Object)response.getExceptionPayload(), (Matcher)Is.is((Matcher)IsNull.nullValue()));
        Assert.assertThat((Object)((Integer)response.getPayload()), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)1)));
        List result = DbTestUtil.selectData("SELECT name FROM Alien", this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, new Record(new Field("NAME", Alien.ET.getName())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MuleMessage doTest(XmlContentBuilder builder) throws Exception {
        DataSource defaultDataSource = this.getDefaultDataSource();
        try (Connection connection = defaultDataSource.getConnection();){
            this.testDatabase.executeUpdate(connection, "DELETE FROM ALIEN");
            LocalMuleClient client = muleContext.getClient();
            HashMap<String, String> messageProperties = new HashMap<String, String>();
            messageProperties.put("name", Alien.ET.getName());
            MuleMessage muleMessage = client.send("vm://insertXmlType", builder.build(connection), messageProperties);
            return muleMessage;
        }
    }

    private static interface XmlContentBuilder {
        public Object build(Connection var1) throws Exception;
    }
}

