/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.sql.Connection;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.api.context.WorkManager;
import org.mule.api.retry.RetryCallback;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.module.db.internal.domain.connection.ConnectionCreationException;
import org.mule.module.db.internal.domain.connection.ConnectionFactory;
import org.mule.module.db.internal.domain.connection.RetryConnectionFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class RetryConnectionFactoryTestCase
extends AbstractMuleTestCase {
    private final RetryPolicyTemplate retryPolicyTemplate = (RetryPolicyTemplate)Mockito.mock(RetryPolicyTemplate.class);
    private final ConnectionFactory delegate = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);
    private final DataSource dataSource = (DataSource)Mockito.mock(DataSource.class);
    private RetryConnectionFactory connectionFactory;

    @Before
    public void init() {
        Mockito.when((Object)this.retryPolicyTemplate.isSynchronous()).thenReturn((Object)true);
        this.connectionFactory = new RetryConnectionFactory(this.retryPolicyTemplate, this.delegate);
    }

    @Test
    public void createsConnection() throws Exception {
        final ArgumentCaptor retryCallbackArgumentCaptor = ArgumentCaptor.forClass(RetryCallback.class);
        Mockito.when((Object)this.retryPolicyTemplate.execute((RetryCallback)retryCallbackArgumentCaptor.capture(), (WorkManager)Matchers.any())).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                RetryCallback retryCallback = (RetryCallback)retryCallbackArgumentCaptor.getValue();
                retryCallback.doWork(null);
                return null;
            }
        });
        Connection expectedConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.delegate.create(this.dataSource)).thenReturn((Object)expectedConnection);
        Connection connection = this.connectionFactory.create(this.dataSource);
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.equalTo((Object)expectedConnection));
    }

    @Test(expected=ConnectionCreationException.class)
    public void failsOnConnectionError() throws Exception {
        ArgumentCaptor retryCallbackArgumentCaptor = ArgumentCaptor.forClass(RetryCallback.class);
        Mockito.when((Object)this.retryPolicyTemplate.execute((RetryCallback)retryCallbackArgumentCaptor.capture(), (WorkManager)Matchers.any())).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                throw new RuntimeException();
            }
        });
        this.connectionFactory.create(this.dataSource);
    }

    @Test(expected=ConnectionCreationException.class)
    public void failsOnNullConnection() throws Exception {
        Object expectedConnection = null;
        Mockito.when((Object)this.dataSource.getConnection()).thenReturn(expectedConnection);
        this.connectionFactory.create(this.dataSource);
    }
}

