/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.transaction.Transaction;
import org.mule.module.db.internal.domain.connection.ConnectionCommitException;
import org.mule.module.db.internal.domain.connection.ConnectionCreationException;
import org.mule.module.db.internal.domain.connection.ConnectionFactory;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.TransactionalDbConnectionFactory;
import org.mule.module.db.internal.domain.transaction.DbTransactionManager;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class TransactionalDbConnectionFactoryTestCase
extends AbstractMuleTestCase {
    private TransactionalDbConnectionFactory factory;
    private DataSource datasource = (DataSource)Mockito.mock(DataSource.class);
    private DbTransactionManager dbTransactionManager = (DbTransactionManager)Mockito.mock(DbTransactionManager.class);
    private ConnectionFactory connectionFactory = (ConnectionFactory)Mockito.mock(ConnectionFactory.class);

    @Test
    public void createsConnectionWhenJoinIfPossibleAndNoActiveTransaction() throws Exception {
        Connection expectedConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connectionFactory.create(this.datasource)).thenReturn((Object)expectedConnection);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, this.connectionFactory, this.datasource);
        DbConnection connection = this.factory.createConnection(TransactionalAction.JOIN_IF_POSSIBLE);
        this.assertWrappedConnection(connection, expectedConnection);
    }

    @Test
    public void createsConnectionWhenJoinIfPossibleAndActiveTransaction() throws Exception {
        Connection expectedConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connectionFactory.create(this.datasource)).thenReturn((Object)expectedConnection);
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)transaction.hasResource((Object)this.datasource)).thenReturn((Object)false);
        Mockito.when((Object)this.dbTransactionManager.getTransaction()).thenReturn((Object)transaction);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, this.connectionFactory, this.datasource);
        DbConnection connection = this.factory.createConnection(TransactionalAction.JOIN_IF_POSSIBLE);
        this.assertWrappedConnection(connection, expectedConnection);
    }

    @Test
    public void createsConnectionWhenNoSupportedAndNoActiveTransaction() throws Exception {
        Connection expectedConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connectionFactory.create(this.datasource)).thenReturn((Object)expectedConnection);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, this.connectionFactory, this.datasource);
        DbConnection connection = this.factory.createConnection(TransactionalAction.NOT_SUPPORTED);
        this.assertWrappedConnection(connection, expectedConnection);
    }

    @Test(expected=IllegalStateException.class)
    public void failsWhenAlwaysJoinAndNoActiveTransaction() throws Exception {
        Connection expectedConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.datasource.getConnection()).thenReturn((Object)expectedConnection);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, null, this.datasource);
        this.factory.createConnection(TransactionalAction.ALWAYS_JOIN);
    }

    @Test
    public void usesConnectionFromActiveTransactionWhenJoinIfPossible() throws Exception {
        this.doUseActiveTransaction(TransactionalAction.JOIN_IF_POSSIBLE);
    }

    private void doUseActiveTransaction(TransactionalAction transactionalAction) throws SQLException {
        Connection expectedConnection = (Connection)Mockito.mock(Connection.class);
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)transaction.hasResource((Object)this.datasource)).thenReturn((Object)true);
        Mockito.when((Object)transaction.getResource((Object)this.datasource)).thenReturn((Object)expectedConnection);
        Mockito.when((Object)this.dbTransactionManager.getTransaction()).thenReturn((Object)transaction);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, null, this.datasource);
        DbConnection connection = this.factory.createConnection(transactionalAction);
        this.assertWrappedConnection(connection, expectedConnection);
        ((DataSource)Mockito.verify((Object)this.datasource, (VerificationMode)Mockito.times((int)0))).getConnection();
    }

    @Test
    public void usesConnectionFromActiveTransactionWhenAlwaysJoin() throws Exception {
        this.doUseActiveTransaction(TransactionalAction.ALWAYS_JOIN);
    }

    @Test
    public void bindsConnectionToActiveTransaction() throws Exception {
        Connection expectedConnection = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)this.connectionFactory.create(this.datasource)).thenReturn((Object)expectedConnection);
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)transaction.hasResource((Object)this.datasource)).thenReturn((Object)false);
        Mockito.when((Object)this.dbTransactionManager.getTransaction()).thenReturn((Object)transaction);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, this.connectionFactory, this.datasource);
        DbConnection connection = this.factory.createConnection(TransactionalAction.JOIN_IF_POSSIBLE);
        this.assertWrappedConnection(connection, expectedConnection);
        ((Transaction)Mockito.verify((Object)transaction, (VerificationMode)Mockito.times((int)1))).bindResource((Object)this.datasource, (Object)expectedConnection);
    }

    @Test
    public void closesConnectionWhenNotSupported() throws Exception {
        Mockito.when((Object)this.dbTransactionManager.getTransaction()).thenReturn(null);
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getTransactionalAction()).thenReturn((Object)TransactionalAction.NOT_SUPPORTED);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, null, null);
        this.factory.releaseConnection(connection);
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).commit();
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test(expected=ConnectionCommitException.class)
    public void closesConnectionWhenNotSupportedAndCommitFails() throws Exception {
        Mockito.when((Object)this.dbTransactionManager.getTransaction()).thenReturn(null);
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getTransactionalAction()).thenReturn((Object)TransactionalAction.NOT_SUPPORTED);
        ((DbConnection)Mockito.doThrow((Throwable)new SQLException()).when((Object)connection)).commit();
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, null, null);
        this.factory.releaseConnection(connection);
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).commit();
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void closesConnectionWhenJoinIfPossibleAndNoActiveTransaction() throws Exception {
        Mockito.when((Object)this.dbTransactionManager.getTransaction()).thenReturn(null);
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getTransactionalAction()).thenReturn((Object)TransactionalAction.JOIN_IF_POSSIBLE);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, null, null);
        this.factory.releaseConnection(connection);
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).commit();
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void keepsTransactedConnectionOpenWhenJoinIfPossibleAndActiveTransaction() throws Exception {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.dbTransactionManager.getTransaction()).thenReturn((Object)transaction);
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getTransactionalAction()).thenReturn((Object)TransactionalAction.JOIN_IF_POSSIBLE);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, null, null);
        this.factory.releaseConnection(connection);
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).commit();
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).close();
    }

    @Test
    public void keepsTransactedConnectionOpenWhenAlwaysJoin() throws Exception {
        Transaction transaction = (Transaction)Mockito.mock(Transaction.class);
        Mockito.when((Object)this.dbTransactionManager.getTransaction()).thenReturn((Object)transaction);
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getTransactionalAction()).thenReturn((Object)TransactionalAction.ALWAYS_JOIN);
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, null, null);
        this.factory.releaseConnection(connection);
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).commit();
        ((DbConnection)Mockito.verify((Object)connection, (VerificationMode)Mockito.times((int)0))).close();
    }

    @Test(expected=SQLException.class)
    public void managesConnectionCreationException() throws Exception {
        Mockito.when((Object)this.connectionFactory.create(this.datasource)).thenThrow(new Throwable[]{new ConnectionCreationException("Error")});
        this.factory = new TransactionalDbConnectionFactory(this.dbTransactionManager, null, this.connectionFactory, this.datasource);
        this.factory.createConnection(TransactionalAction.NOT_SUPPORTED);
    }

    private void assertWrappedConnection(DbConnection connection, Connection wrappedConnection) throws SQLException {
        String sqlText = "select * from test";
        connection.prepareStatement("select * from test");
        ((Connection)Mockito.verify((Object)wrappedConnection)).prepareStatement("select * from test");
    }
}

