/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.database;

import com.mchange.v2.c3p0.PooledDataSource;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.api.lifecycle.Disposable;
import org.mule.module.db.internal.domain.connection.DbPoolingProfile;
import org.mule.module.db.internal.domain.database.DataSourceConfig;
import org.mule.module.db.internal.domain.database.DataSourceFactory;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DataSourceFactoryTestCase
extends AbstractMuleTestCase {
    private final PooledDataSource dataSource = (PooledDataSource)Mockito.mock(PooledDataSource.class);
    private final DisposableDataSource disposableDataSource = (DisposableDataSource)Mockito.mock(DisposableDataSource.class);
    private final DataSourceFactory dataSourceFactory = new DataSourceFactory("test"){

        protected DataSource createPooledDataSource(DataSourceConfig dataSourceConfig) throws SQLException {
            return DataSourceFactoryTestCase.this.dataSource;
        }

        public DataSource decorateDataSource(DataSource dataSource, DbPoolingProfile poolingProfile, MuleContext muleContext) {
            return DataSourceFactoryTestCase.this.disposableDataSource;
        }
    };

    @Test
    public void destroysPooledDataSource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setPoolingProfile((DbPoolingProfile)Mockito.mock(DbPoolingProfile.class));
        this.doCloseTest(dataSourceConfig, 1);
    }

    @Test
    public void doesNotDestroySingleDataSource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        this.doCloseTest(dataSourceConfig, 0);
    }

    @Test
    public void doesNotDestroySingleXaDataSource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUseXaTransactions(true);
        this.doCloseTest(dataSourceConfig, 0);
    }

    @Test
    public void doesNotDestroyPooledXaDataSource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUseXaTransactions(true);
        dataSourceConfig.setPoolingProfile((DbPoolingProfile)Mockito.mock(DbPoolingProfile.class));
        this.doCloseTest(dataSourceConfig, 0);
    }

    @Test
    public void doesNotDisposesPooledDataSource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setPoolingProfile((DbPoolingProfile)Mockito.mock(DbPoolingProfile.class));
        this.doDisposeTest(dataSourceConfig, 0);
    }

    @Test
    public void doesNotDisposesSingleDataSource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        this.doDisposeTest(dataSourceConfig, 0);
    }

    @Test
    public void disposesSingleXaDataSource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUseXaTransactions(true);
        this.doDisposeTest(dataSourceConfig, 1);
    }

    @Test
    public void disposesPooledXaDataSource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUseXaTransactions(true);
        dataSourceConfig.setPoolingProfile((DbPoolingProfile)Mockito.mock(DbPoolingProfile.class));
        this.doDisposeTest(dataSourceConfig, 1);
    }

    @Test
    public void disposesDisposableDatasource() throws Exception {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUseXaTransactions(true);
        this.doDisposeTest(dataSourceConfig, 1);
    }

    private void doCloseTest(DataSourceConfig dataSourceConfig, int expectedCloseInvocations) throws SQLException {
        this.configureFactory(dataSourceConfig);
        ((PooledDataSource)Mockito.verify((Object)this.dataSource, (VerificationMode)Mockito.times((int)expectedCloseInvocations))).close(false);
    }

    private void doDisposeTest(DataSourceConfig dataSourceConfig, int expectedDisposeInvocations) throws SQLException {
        this.configureFactory(dataSourceConfig);
        ((DisposableDataSource)Mockito.verify((Object)this.disposableDataSource, (VerificationMode)Mockito.times((int)expectedDisposeInvocations))).dispose();
    }

    private void configureFactory(DataSourceConfig dataSourceConfig) throws SQLException {
        this.dataSourceFactory.create(dataSourceConfig);
        this.dataSourceFactory.dispose();
    }

    public static interface DisposableDataSource
    extends DataSource,
    Disposable {
    }
}

