/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.config.ReaderInputStream;
import org.mule.module.db.internal.domain.type.ClobResolvedDataType;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ClobResolvedDataTypeTestCase
extends AbstractMuleTestCase {
    private static final int PARAM_INDEX = 1;
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private ClobResolvedDataType dataType;
    private PreparedStatement statement;
    private Connection connection;
    private Clob clob;

    @Before
    public void setUp() throws Exception {
        this.dataType = new ClobResolvedDataType(2005, null);
        this.statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        this.connection = (Connection)Mockito.mock(Connection.class);
        this.clob = (Clob)Mockito.mock(Clob.class);
        Mockito.when((Object)this.statement.getConnection()).thenReturn((Object)this.connection);
        Mockito.when((Object)this.connection.createClob()).thenReturn((Object)this.clob);
    }

    @Test
    public void convertsStringToClob() throws Exception {
        String value = "foo";
        this.dataType.setParameterValue(this.statement, 1, (Object)value);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setCharacterStream(Matchers.eq((int)1), (Reader)Matchers.any(StringReader.class), Matchers.eq((int)value.length()));
        ((PreparedStatement)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.never())).setObject(1, (Object)this.clob, 2005);
    }

    @Test
    public void convertsInputStreamToClob() throws Exception {
        String streamContent = "bar";
        StringInputStream value = new StringInputStream(streamContent);
        this.dataType.setParameterValue(this.statement, 1, (Object)value);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setCharacterStream(Matchers.eq((int)1), (Reader)Matchers.any(StringReader.class), Matchers.eq((int)streamContent.length()));
        ((PreparedStatement)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.never())).setObject(1, (Object)this.clob, 2005);
    }

    @Test
    public void setClobDirectly() throws Exception {
        Clob clob = (Clob)Mockito.mock(Clob.class);
        this.dataType.setParameterValue(this.statement, 1, (Object)clob);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(1, (Object)clob, 2005);
    }

    @Test
    public void failsToConvertUnsupportedType() throws Exception {
        Object value = new Object();
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(org.hamcrest.Matchers.containsString((String)ClobResolvedDataType.createUnsupportedTypeErrorMessage((Object)value)));
        this.dataType.setParameterValue(this.statement, 1, value);
    }

    private static class StringInputStream
    extends ReaderInputStream {
        public StringInputStream(String source) {
            super((Reader)new StringReader(source));
        }
    }
}

