/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.JdbcTypes;
import org.mule.module.db.internal.domain.type.StaticDbTypeManager;
import org.mule.module.db.internal.domain.type.UnknownDbTypeException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StaticDbTypeManagerTestCase
extends AbstractMuleTestCase {
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final StaticDbTypeManager typeManager = new StaticDbTypeManager(Arrays.asList(JdbcTypes.VARCHAR_DB_TYPE));

    @Test
    public void resolvesByName() throws Exception {
        DbType lookup = this.typeManager.lookup(this.connection, JdbcTypes.VARCHAR_DB_TYPE.getName());
        Assert.assertThat((Object)lookup, (Matcher)CoreMatchers.sameInstance((Object)JdbcTypes.VARCHAR_DB_TYPE));
    }

    @Test(expected=UnknownDbTypeException.class)
    public void failsWhenNoTypeDefined() throws Exception {
        this.typeManager.lookup(this.connection, "NonRegisteredType");
    }

    @Test(expected=UnknownDbTypeException.class)
    public void doesNotResolveByNameAndId() throws Exception {
        this.typeManager.lookup(this.connection, 0, JdbcTypes.VARCHAR_DB_TYPE.getName());
    }
}

