/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.xa;

import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.runners.MockitoJUnitRunner;
import org.mule.api.MuleContext;
import org.mule.module.db.internal.domain.xa.DataSourceWrapper;
import org.mule.module.db.internal.domain.xa.DefaultDataSourceDecorator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class DefaultDataSourceDecoratorTestCase
extends AbstractMuleTestCase {
    public static final String DATA_SOURCE_NAME = "name";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DataSource mockDataSource;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DataSourceWrapper mockDataSourceWrapper;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, extraInterfaces={XADataSource.class})
    private DataSourceWrapper mockXaDataSourceWrapper;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS, extraInterfaces={XADataSource.class})
    private DataSource mockXaDataSource;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;
    private DefaultDataSourceDecorator decorator = new DefaultDataSourceDecorator();

    @Test
    public void appliesToDataSource() {
        Assert.assertThat((Object)this.decorator.appliesTo(this.mockDataSource, this.mockMuleContext), (Matcher)Is.is((Object)false));
    }

    @Test
    public void appliesToXaDataSource() {
        Assert.assertThat((Object)this.decorator.appliesTo(this.mockXaDataSource, this.mockMuleContext), (Matcher)Is.is((Object)true));
    }

    @Test
    public void appliesToDataSourceWrapper() {
        Assert.assertThat((Object)this.decorator.appliesTo(this.mockDataSource, this.mockMuleContext), (Matcher)Is.is((Object)false));
    }

    @Test
    public void appliesToXaDataSourceWrapper() {
        Assert.assertThat((Object)this.decorator.appliesTo((DataSource)this.mockXaDataSourceWrapper, this.mockMuleContext), (Matcher)Is.is((Object)false));
    }

    @Test(expected=IllegalStateException.class)
    public void dcorateDataSource() {
        this.decorator.decorate(this.mockDataSource, DATA_SOURCE_NAME, null, this.mockMuleContext);
    }

    @Test
    public void decorateXaDataSource() {
        this.decorator.decorate(this.mockXaDataSource, DATA_SOURCE_NAME, null, this.mockMuleContext);
    }

    @Test(expected=IllegalStateException.class)
    public void decorateDataSourceWrapper() {
        this.decorator.decorate(this.mockDataSource, DATA_SOURCE_NAME, null, this.mockMuleContext);
    }

    @Test(expected=IllegalStateException.class)
    public void decorateXaDataSourceWrapper() {
        this.decorator.decorate((DataSource)this.mockXaDataSourceWrapper, DATA_SOURCE_NAME, null, this.mockMuleContext);
    }
}

