/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.MuleEvent;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.module.db.internal.debug.DbDebugInfoTestUtils;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.query.BulkQuery;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.BulkExecuteMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.query.BulkQueryResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
public class BulkExecuteMessageProcessorDebugInfoTestCase
extends AbstractMuleTestCase {
    public static final String DELETE_QUERY = "DELETE FROM PLANET";
    public static final QueryTemplate QUERY_TEMPLATE1 = new QueryTemplate("DELETE FROM PLANET", QueryType.DELETE, Collections.emptyList());
    public static final String INSERT_QUERY = "INSERT INTO PLANET(POSITION, NAME) VALUES (6, 'Saturn')";
    public static final QueryTemplate QUERY_TEMPLATE2 = new QueryTemplate("INSERT INTO PLANET(POSITION, NAME) VALUES (6, 'Saturn')", QueryType.INSERT, Collections.emptyList());
    public static final String QUERY1 = "Query1";
    public static final String QUERY2 = "Query2";
    private final MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
    private final DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
    private final DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
    private final BulkQueryResolver bulkQueryResolver = (BulkQueryResolver)Mockito.mock(BulkQueryResolver.class);

    @Test
    public void returnsDebugInfo() throws Exception {
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        BulkQuery bulkQuery = new BulkQuery();
        bulkQuery.add(new QueryTemplate(DELETE_QUERY, QueryType.DELETE, Collections.emptyList()));
        bulkQuery.add(new QueryTemplate(INSERT_QUERY, QueryType.INSERT, Collections.emptyList()));
        Mockito.when((Object)this.bulkQueryResolver.resolve(this.event)).thenReturn((Object)bulkQuery);
        BulkExecuteMessageProcessor bulkExecuteMessageProcessor = new BulkExecuteMessageProcessor(this.dbConfigResolver, this.bulkQueryResolver, null, TransactionalAction.NOT_SUPPORTED);
        List debugInfo = bulkExecuteMessageProcessor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Queries", List.class, this.createExpectedQueryMatchers())));
    }

    @Test
    public void returnsErrorDebugInfoWhenCannotResolveQueries() throws Exception {
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        QueryResolutionException queryResolutionException = new QueryResolutionException("Error");
        Mockito.when((Object)this.bulkQueryResolver.resolve(this.event)).thenThrow(new Throwable[]{queryResolutionException});
        BulkExecuteMessageProcessor bulkExecuteMessageProcessor = new BulkExecuteMessageProcessor(this.dbConfigResolver, this.bulkQueryResolver, null, TransactionalAction.NOT_SUPPORTED);
        List debugInfo = bulkExecuteMessageProcessor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Queries", List.class, (Object)queryResolutionException)));
    }

    @Test
    public void returnsErrorDebugInfoOnInvalidResolvedQuery() throws Exception {
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        BulkQuery bulkQuery = new BulkQuery();
        bulkQuery.add(new QueryTemplate(DELETE_QUERY, QueryType.SELECT, Collections.emptyList()));
        bulkQuery.add(new QueryTemplate(INSERT_QUERY, QueryType.INSERT, Collections.emptyList()));
        Mockito.when((Object)this.bulkQueryResolver.resolve(this.event)).thenReturn((Object)bulkQuery);
        BulkExecuteMessageProcessor bulkExecuteMessageProcessor = new BulkExecuteMessageProcessor(this.dbConfigResolver, this.bulkQueryResolver, null, TransactionalAction.NOT_SUPPORTED);
        List debugInfo = bulkExecuteMessageProcessor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        FieldDebugInfo fieldDebugInfo = (FieldDebugInfo)debugInfo.get(0);
        MatcherAssert.assertThat((Object)fieldDebugInfo.getName(), (Matcher)Matchers.equalTo((Object)"Queries"));
        MatcherAssert.assertThat((Object)fieldDebugInfo.getType(), (Matcher)Matchers.equalTo((Object)List.class.getName()));
        MatcherAssert.assertThat((Object)fieldDebugInfo.getValue(), (Matcher)Matchers.instanceOf(IllegalArgumentException.class));
    }

    private List<Matcher<FieldDebugInfo<?>>> createExpectedQueryMatchers() {
        ArrayList queriesDebugInfo = new ArrayList();
        queriesDebugInfo.add(DbDebugInfoTestUtils.createQueryFieldDebugInfoMatcher(QUERY1, QUERY_TEMPLATE1));
        queriesDebugInfo.add(DbDebugInfoTestUtils.createQueryFieldDebugInfoMatcher(QUERY2, QUERY_TEMPLATE2));
        return queriesDebugInfo;
    }
}

