/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleMessage;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.module.db.internal.debug.DbDebugInfoTestUtils;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.processor.DynamicBulkUpdateMessageProcessor;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.module.db.internal.resolver.query.QueryResolutionException;
import org.mule.module.db.internal.resolver.query.QueryResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;
import org.mule.tck.size.SmallTest;

@SmallTest
public class DynamicBulkUpdateMessageProcessorTestCase
extends AbstractMuleTestCase {
    public static final QueryTemplate QUERY_TEMPLATE1 = new QueryTemplate("update PLANET set NAME='Mercury' where NAME='EARTH'", QueryType.UPDATE, Collections.emptyList());
    public static final QueryTemplate QUERY_TEMPLATE2 = new QueryTemplate("update PLANET set NAME='Mercury' where NAME='MARS'", QueryType.UPDATE, Collections.emptyList());
    public static final String QUERY1 = "Query1";
    public static final String QUERY2 = "Query2";
    private final MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
    private final MuleMessage message = (MuleMessage)Mockito.mock(MuleMessage.class);
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
    private final DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
    private final DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
    private final QueryResolver queryResolver = (QueryResolver)Mockito.mock(QueryResolver.class);
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class, (Answer)Mockito.RETURNS_DEEP_STUBS);

    @Test
    public void returnsDebugInfo() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn(DynamicBulkUpdateMessageProcessorTestCase.getPlanetNames());
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        Mockito.when((Object)this.queryResolver.resolve((DbConnection)org.mockito.Matchers.any(DbConnection.class), (MuleEvent)org.mockito.Matchers.any(MuleEvent.class))).thenReturn((Object)new Query(QUERY_TEMPLATE1)).thenReturn((Object)new Query(QUERY_TEMPLATE2));
        DynamicBulkUpdateMessageProcessor dynamicBulkUpdateMessageProcessor = new DynamicBulkUpdateMessageProcessor(this.dbConfigResolver, this.queryResolver, null, TransactionalAction.NOT_SUPPORTED, Collections.singletonList(QueryType.UPDATE));
        dynamicBulkUpdateMessageProcessor.setMuleContext(this.muleContext);
        List debugInfo = dynamicBulkUpdateMessageProcessor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Queries", List.class, this.createExpectedQueryMatchers())));
    }

    @Test
    public void returnsErrorDebugInfoWhenCannotResolveQueries() throws Exception {
        Mockito.when((Object)this.message.getPayload()).thenReturn(DynamicBulkUpdateMessageProcessorTestCase.getPlanetNames());
        Mockito.when((Object)this.event.getMessage()).thenReturn((Object)this.message);
        Mockito.when((Object)this.dbConnectionFactory.createConnection(TransactionalAction.NOT_SUPPORTED)).thenReturn((Object)this.connection);
        Mockito.when((Object)this.dbConfigResolver.resolve(this.event)).thenReturn((Object)this.dbConfig);
        Mockito.when((Object)this.dbConfig.getConnectionFactory()).thenReturn((Object)this.dbConnectionFactory);
        QueryResolutionException queryResolutionException = new QueryResolutionException("Error");
        Mockito.when((Object)this.queryResolver.resolve((DbConnection)org.mockito.Matchers.any(DbConnection.class), (MuleEvent)org.mockito.Matchers.any(MuleEvent.class))).thenThrow(new Throwable[]{queryResolutionException});
        DynamicBulkUpdateMessageProcessor dynamicBulkUpdateMessageProcessor = new DynamicBulkUpdateMessageProcessor(this.dbConfigResolver, this.queryResolver, null, TransactionalAction.NOT_SUPPORTED, Collections.singletonList(QueryType.UPDATE));
        dynamicBulkUpdateMessageProcessor.setMuleContext(this.muleContext);
        List debugInfo = dynamicBulkUpdateMessageProcessor.getDebugInfo(this.event);
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)FieldDebugInfoMatcher.fieldLike((String)"Queries", List.class, (Object)queryResolutionException)));
    }

    private List<Matcher<FieldDebugInfo<?>>> createExpectedQueryMatchers() {
        ArrayList queryMatchers = new ArrayList();
        queryMatchers.add(DbDebugInfoTestUtils.createQueryFieldDebugInfoMatcher(QUERY1, QUERY_TEMPLATE1));
        queryMatchers.add(DbDebugInfoTestUtils.createQueryFieldDebugInfoMatcher(QUERY2, QUERY_TEMPLATE2));
        return queryMatchers;
    }

    private static List<String> getPlanetNames() {
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add("EARTH");
        planetNames.add("MARS");
        return planetNames;
    }
}

