/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.database;

import javax.sql.DataSource;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleEvent;
import org.mule.api.lifecycle.Disposable;
import org.mule.common.Result;
import org.mule.common.TestResult;
import org.mule.common.metadata.MetaDataKey;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.StaticDbConfigResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public class StaticDbConfigResolverTestCase
extends AbstractMuleTestCase {
    private final DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
    private final StaticDbConfigResolver dbConfigResolver = new StaticDbConfigResolver(this.dbConfig);

    @Test
    public void resolvesDbConfig() throws Exception {
        MuleEvent muleEvent = (MuleEvent)Mockito.mock(MuleEvent.class);
        DbConfig resolvedDbConfig = this.dbConfigResolver.resolve(muleEvent);
        MatcherAssert.assertThat((Object)resolvedDbConfig, (Matcher)Is.is((Object)this.dbConfig));
    }

    @Test
    public void testsConnection() throws Exception {
        TestResult expectedTestResult = (TestResult)Mockito.mock(TestResult.class);
        Mockito.when((Object)this.dbConfig.test()).thenReturn((Object)expectedTestResult);
        TestResult testResult = this.dbConfigResolver.test();
        MatcherAssert.assertThat((Object)testResult, (Matcher)Is.is((Object)expectedTestResult));
    }

    @Test
    public void returnsMetaDataKeys() throws Exception {
        Result expectedMetaDataResult = (Result)Mockito.mock(Result.class);
        Mockito.when((Object)this.dbConfig.getMetaDataKeys()).thenReturn((Object)expectedMetaDataResult);
        Result metaDataResult = this.dbConfigResolver.getMetaDataKeys();
        MatcherAssert.assertThat((Object)metaDataResult, (Matcher)Is.is((Object)expectedMetaDataResult));
    }

    @Test
    public void returnsMetaData() throws Exception {
        Result expectedMetaData = (Result)Mockito.mock(Result.class);
        MetaDataKey metaDataKey = (MetaDataKey)Mockito.mock(MetaDataKey.class);
        Mockito.when((Object)this.dbConfig.getMetaData(metaDataKey)).thenReturn((Object)expectedMetaData);
        Result metaData = this.dbConfigResolver.getMetaData(metaDataKey);
        MatcherAssert.assertThat((Object)metaData, (Matcher)Is.is((Object)expectedMetaData));
    }

    @Test
    public void disposesDisposableDbConfig() throws Exception {
        DisposableDataSource dataSource = (DisposableDataSource)Mockito.mock(DisposableDataSource.class);
        Mockito.when((Object)this.dbConfig.getDataSource()).thenReturn((Object)dataSource);
        this.dbConfigResolver.dispose();
        ((DisposableDataSource)Mockito.verify((Object)dataSource, (VerificationMode)Mockito.times((int)1))).dispose();
    }

    private static interface DisposableDataSource
    extends DataSource,
    Disposable {
    }
}

