/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.resolver.param;

import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.module.db.internal.domain.query.QueryParamValue;
import org.mule.module.db.internal.resolver.param.AbstractQueryParamResolverTestCase;
import org.mule.module.db.internal.resolver.param.StaticParamValueResolver;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StaticParamValueResolverTestCase
extends AbstractQueryParamResolverTestCase {
    private final StaticParamValueResolver paramResolver = new StaticParamValueResolver();

    @Test
    public void resolvesStaticParam() throws Exception {
        List<QueryParamValue> templateParams = this.getQueryParamValues(777);
        List resolvedParams = this.paramResolver.resolveParams(this.muleEvent, templateParams);
        Assert.assertThat((Object)resolvedParams, (Matcher)CoreMatchers.equalTo(templateParams));
    }

    @Test
    public void returnsOriginalExpressionParam() throws Exception {
        List<QueryParamValue> templateParams = this.getQueryParamValues("#[payload]");
        List resolvedParams = this.paramResolver.resolveParams(this.muleEvent, templateParams);
        Assert.assertThat((Object)resolvedParams, (Matcher)CoreMatchers.equalTo(templateParams));
    }

    @Test
    public void resolveMultipleParams() throws Exception {
        List<QueryParamValue> templateParams = this.getQueryParamValues("#[payload]", 777);
        List resolvedParams = this.paramResolver.resolveParams(this.muleEvent, templateParams);
        Assert.assertThat((Object)resolvedParams, (Matcher)CoreMatchers.equalTo(templateParams));
    }
}

