/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result;

import java.sql.ResultSet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.result.resultset.ResultSetIterator;
import org.mule.module.db.internal.result.resultset.StreamingResultSetCloser;
import org.mule.module.db.internal.result.row.RowHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class ResultSetIteratorTestCase
extends AbstractMuleTestCase {
    private final ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
    private final RowHandler rowHandler = (RowHandler)Mockito.mock(RowHandler.class);
    private final StreamingResultSetCloser streamingResultSetCloser = (StreamingResultSetCloser)Mockito.mock(StreamingResultSetCloser.class);
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final ResultSetIterator resultSetIterator = new ResultSetIterator(this.connection, this.resultSet, this.rowHandler, this.streamingResultSetCloser);

    @Test
    public void detectsNoMoreRecordsWhenRecordCached() throws Exception {
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)false);
        boolean result = this.resultSetIterator.hasNext();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)false));
        ((ResultSet)Mockito.verify((Object)this.resultSet)).next();
    }

    @Test
    public void detectsMoreRecordsWhenRecordCached() throws Exception {
        Mockito.when((Object)this.resultSet.next()).thenReturn((Object)true);
        this.resultSetIterator.hasNext();
        boolean result = this.resultSetIterator.hasNext();
        Assert.assertThat((Object)result, (Matcher)CoreMatchers.equalTo((Object)true));
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)1))).next();
    }

    @Test
    public void returnsNextRecord() throws Exception {
        this.resultSetIterator.next();
        ((ResultSet)Mockito.verify((Object)this.resultSet)).next();
        ((RowHandler)Mockito.verify((Object)this.rowHandler)).process(this.resultSet);
    }

    @Test
    public void returnsNextRecordFromCachedInvocation() throws Exception {
        this.resultSetIterator.hasNext();
        this.resultSetIterator.next();
        ((ResultSet)Mockito.verify((Object)this.resultSet)).next();
        ((RowHandler)Mockito.verify((Object)this.rowHandler)).process(this.resultSet);
    }

    @Test
    public void clearsCachedInvocation() throws Exception {
        this.resultSetIterator.hasNext();
        this.resultSetIterator.next();
        this.resultSetIterator.next();
        ((ResultSet)Mockito.verify((Object)this.resultSet, (VerificationMode)Mockito.times((int)2))).next();
        ((RowHandler)Mockito.verify((Object)this.rowHandler, (VerificationMode)Mockito.times((int)2))).process(this.resultSet);
    }
}

