/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.result.statement;

import java.util.HashMap;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.api.Closeable;
import org.mule.api.DefaultMuleException;
import org.mule.module.db.internal.result.statement.CloseableMap;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class CloseableMapTest
extends AbstractMuleTestCase {
    public static final String FOO_KEY = "foo";
    public static final Object FOO_VALUE = new Object();
    public static final String BAR_KEY = "bar";
    public static final Object BAR_VALUE = new Object();
    public static final String INVALID_KEY = "oops";
    public static final String NEW_KEY_1 = "key1";
    public static final String NEW_KEY_2 = "key2";
    private final CloseableMap<String, Object> closeableMap = new CloseableMap();

    @Before
    public void fillTestData() throws Exception {
        this.closeableMap.put((Object)FOO_KEY, FOO_VALUE);
        this.closeableMap.put((Object)BAR_KEY, BAR_VALUE);
    }

    @Test
    public void closesCloseableElements() throws Exception {
        Closeable closeable = (Closeable)Mockito.mock(Closeable.class);
        this.closeableMap.put((Object)NEW_KEY_1, (Object)closeable);
        this.closeableMap.close();
        ((Closeable)Mockito.verify((Object)closeable)).close();
    }

    @Test
    public void closesCloseableElementsBesidesOfExceptions() throws Exception {
        Closeable closeable1 = (Closeable)Mockito.mock(Closeable.class);
        ((Closeable)Mockito.doThrow((Throwable)new DefaultMuleException("Error")).when((Object)closeable1)).close();
        this.closeableMap.put((Object)NEW_KEY_1, (Object)closeable1);
        Closeable closeable2 = (Closeable)Mockito.mock(Closeable.class);
        this.closeableMap.put((Object)NEW_KEY_2, (Object)closeable2);
        this.closeableMap.close();
        ((Closeable)Mockito.verify((Object)closeable1)).close();
        ((Closeable)Mockito.verify((Object)closeable2)).close();
    }

    @Test
    public void delegatesSize() throws Exception {
        Assert.assertThat((Object)this.closeableMap.size(), (Matcher)CoreMatchers.equalTo((Object)2));
    }

    @Test
    public void delegatesIsEmpty() throws Exception {
        Assert.assertThat((Object)this.closeableMap.isEmpty(), (Matcher)CoreMatchers.equalTo((Object)false));
        this.closeableMap.clear();
        Assert.assertThat((Object)this.closeableMap.isEmpty(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void delegatesContainsKey() throws Exception {
        Assert.assertThat((Object)this.closeableMap.containsKey((Object)FOO_KEY), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.closeableMap.containsKey((Object)INVALID_KEY), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void delegatesContainsValue() throws Exception {
        Assert.assertThat((Object)this.closeableMap.containsValue(FOO_VALUE), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.closeableMap.containsValue(new Object()), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void delegatesGet() throws Exception {
        Assert.assertThat((Object)this.closeableMap.get((Object)FOO_KEY), (Matcher)CoreMatchers.equalTo((Object)FOO_VALUE));
        Assert.assertThat((Object)this.closeableMap.get((Object)INVALID_KEY), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void delegatesPut() throws Exception {
        Object newFooValue = new Object();
        this.closeableMap.put((Object)FOO_KEY, newFooValue);
        Assert.assertThat((Object)this.closeableMap.get((Object)FOO_KEY), (Matcher)CoreMatchers.equalTo((Object)newFooValue));
    }

    @Test
    public void delegatesRemove() throws Exception {
        Assert.assertThat((Object)this.closeableMap.remove((Object)FOO_KEY), (Matcher)CoreMatchers.equalTo((Object)FOO_VALUE));
        Assert.assertThat((Object)this.closeableMap.remove((Object)INVALID_KEY), (Matcher)CoreMatchers.equalTo(null));
    }

    @Test
    public void delegatesPutAll() throws Exception {
        HashMap<String, Object> newValues = new HashMap<String, Object>();
        newValues.put(NEW_KEY_1, new Object());
        newValues.put(NEW_KEY_2, new Object());
        this.closeableMap.putAll(newValues);
        Assert.assertThat((Object)this.closeableMap.containsKey((Object)NEW_KEY_1), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((Object)this.closeableMap.containsKey((Object)NEW_KEY_2), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

