/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sql.executor;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.executor.SelectExecutor;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.statement.StatementFactory;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class QueryTestCase
extends AbstractMuleTestCase {
    @Test
    public void testQueryReturnsTheExpectedResult() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Statement statement = (Statement)Mockito.mock(Statement.class);
        String sqlText = "SELECT * FROM dummy";
        Mockito.when((Object)statement.executeQuery(sqlText)).thenReturn((Object)resultSet);
        StatementFactory statementFactory = (StatementFactory)Mockito.mock(StatementFactory.class);
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        ResultSetHandler resultHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
        ArrayList processedResult = new ArrayList();
        Mockito.when((Object)resultHandler.processResultSet(connection, resultSet)).thenReturn(processedResult);
        SelectExecutor selectExecutor = new SelectExecutor(statementFactory, resultHandler);
        QueryTemplate queryTemplate = new QueryTemplate(sqlText, QueryType.SELECT, Collections.emptyList());
        Mockito.when((Object)statementFactory.create(connection, queryTemplate)).thenReturn((Object)statement);
        Query query = new Query(queryTemplate, null);
        Object result = selectExecutor.execute(connection, query);
        Assert.assertEquals(processedResult, (Object)result);
    }
}

