/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.sql.executor;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.mule.module.db.internal.domain.autogeneratedkey.AutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.autogeneratedkey.NoAutoGeneratedKeyStrategy;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.param.DefaultOutputQueryParam;
import org.mule.module.db.internal.domain.query.QueryTemplate;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.domain.type.UnknownDbType;
import org.mule.module.db.internal.result.resultset.ResultSetHandler;
import org.mule.module.db.internal.result.statement.OutputParamResult;
import org.mule.module.db.internal.result.statement.ResultSetResult;
import org.mule.module.db.internal.result.statement.StatementResult;
import org.mule.module.db.internal.result.statement.StatementResultIterator;
import org.mule.module.db.internal.result.statement.UpdateCountResult;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class StatementResultIteratorTestCase
extends AbstractMuleTestCase {
    private final CallableStatement statement = (CallableStatement)Mockito.mock(CallableStatement.class);
    private final QueryTemplate queryTemplate = new QueryTemplate("dummy", QueryType.STORE_PROCEDURE_CALL, Collections.EMPTY_LIST);
    private final DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
    private final ResultSetHandler resultSetHandler = (ResultSetHandler)Mockito.mock(ResultSetHandler.class);
    private final StatementResultIterator iterator = new StatementResultIterator(this.connection, (Statement)this.statement, this.queryTemplate, (AutoGeneratedKeyStrategy)new NoAutoGeneratedKeyStrategy(), this.resultSetHandler);

    @Before
    public void configureConnectionMetadata() throws Exception {
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)this.connection.getMetaData()).thenReturn((Object)metaData);
    }

    @Before
    public void configureResultSetHandler() throws Exception {
        Mockito.when((Object)this.resultSetHandler.processResultSet((DbConnection)org.mockito.Matchers.argThat((Matcher)Matchers.any(DbConnection.class)), (ResultSet)org.mockito.Matchers.argThat((Matcher)Matchers.any(ResultSet.class)))).then((Answer)new Answer<Object>(){

            public Object answer(InvocationOnMock invocationOnMock) throws Throwable {
                return invocationOnMock.getArguments()[1];
            }
        });
    }

    @Test
    public void detectHasResultSet() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.statement.getResultSet()).thenReturn((Object)resultSet);
        boolean hasNext = this.iterator.hasNext();
        Assert.assertThat((Object)hasNext, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void detectHasUpdateCount() throws Exception {
        int updateCount = 10;
        Mockito.when((Object)this.statement.getUpdateCount()).thenReturn((Object)updateCount);
        boolean hasNext = this.iterator.hasNext();
        Assert.assertThat((Object)hasNext, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void detectHasOutputParam() throws Exception {
        Mockito.when((Object)this.statement.getResultSet()).thenReturn(null);
        Mockito.when((Object)this.statement.getUpdateCount()).thenReturn((Object)-1);
        DefaultOutputQueryParam param1 = new DefaultOutputQueryParam(0, UnknownDbType.getInstance(), "param1");
        LinkedList<DefaultOutputQueryParam> params = new LinkedList<DefaultOutputQueryParam>();
        params.add(param1);
        QueryTemplate queryTemplate = new QueryTemplate("dummy", QueryType.STORE_PROCEDURE_CALL, params);
        StatementResultIterator iterator = new StatementResultIterator(null, (Statement)this.statement, queryTemplate, null, null);
        boolean hasNext = iterator.hasNext();
        Assert.assertThat((Object)hasNext, (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void returnsResultSetInNextResult() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.statement.getResultSet()).thenReturn((Object)resultSet);
        StatementResult nextResult = this.iterator.next();
        Assert.assertThat((Object)nextResult, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(ResultSetResult.class)));
        ResultSetResult resultSetResult = (ResultSetResult)nextResult;
        Assert.assertThat((Object)resultSetResult.getName(), (Matcher)CoreMatchers.equalTo((Object)"resultSet1"));
        Assert.assertThat((Object)((ResultSet)resultSetResult.getResult()), (Matcher)CoreMatchers.equalTo((Object)resultSet));
    }

    @Test
    public void returnsUpdateCountInNextResult() throws Exception {
        int updateCount = 10;
        Mockito.when((Object)this.statement.getUpdateCount()).thenReturn((Object)updateCount);
        StatementResult nextResult = this.iterator.next();
        Assert.assertThat((Object)nextResult, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(UpdateCountResult.class)));
        UpdateCountResult updateCountResult = (UpdateCountResult)nextResult;
        Assert.assertThat((Object)updateCountResult.getName(), (Matcher)CoreMatchers.equalTo((Object)"updateCount1"));
        Assert.assertThat((Object)((Integer)updateCountResult.getResult()), (Matcher)CoreMatchers.equalTo((Object)updateCount));
    }

    @Test
    public void returnsOutputParamInNextResult() throws Exception {
        int paramValue = 7;
        Mockito.when((Object)this.statement.getResultSet()).thenReturn(null);
        Mockito.when((Object)this.statement.getUpdateCount()).thenReturn((Object)-1);
        Mockito.when((Object)this.statement.getObject(1)).thenReturn((Object)7);
        DefaultOutputQueryParam param1 = new DefaultOutputQueryParam(1, UnknownDbType.getInstance(), "param1");
        LinkedList<DefaultOutputQueryParam> params = new LinkedList<DefaultOutputQueryParam>();
        params.add(param1);
        QueryTemplate queryTemplate = new QueryTemplate("dummy", QueryType.STORE_PROCEDURE_CALL, params);
        StatementResultIterator iterator = new StatementResultIterator(null, (Statement)this.statement, queryTemplate, null, null);
        StatementResult nextResult = iterator.next();
        Assert.assertThat((Object)nextResult, (Matcher)Is.is((Matcher)IsInstanceOf.instanceOf(OutputParamResult.class)));
        OutputParamResult outputParamResult = (OutputParamResult)nextResult;
        Assert.assertThat((Object)outputParamResult.getName(), (Matcher)CoreMatchers.equalTo((Object)"param1"));
        Assert.assertThat((Object)((Integer)outputParamResult.getResult()), (Matcher)CoreMatchers.equalTo((Object)paramValue));
    }

    @Test
    public void processResultSetOnce() throws Exception {
        Mockito.when((Object)this.statement.getResultSet()).thenReturn(Mockito.mock(ResultSet.class));
        this.iterator.next();
        this.iterator.next();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.statement});
        ((CallableStatement)inOrder.verify((Object)this.statement)).getResultSet();
        ((CallableStatement)inOrder.verify((Object)this.statement)).getMoreResults();
    }

    @Test
    public void processUpdateCountOnce() throws Exception {
        Mockito.when((Object)this.statement.getUpdateCount()).thenReturn((Object)10);
        this.iterator.next();
        this.iterator.next();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.statement});
        ((CallableStatement)inOrder.verify((Object)this.statement)).getUpdateCount();
        ((CallableStatement)inOrder.verify((Object)this.statement)).getMoreResults();
    }

    @Test
    public void processOutputParamOnce() throws Exception {
        Mockito.when((Object)this.statement.getResultSet()).thenReturn(null);
        Mockito.when((Object)this.statement.getUpdateCount()).thenReturn((Object)-1);
        Mockito.when((Object)this.statement.getObject(1)).thenReturn((Object)7);
        DefaultOutputQueryParam param1 = new DefaultOutputQueryParam(1, UnknownDbType.getInstance(), "param1");
        DefaultOutputQueryParam param2 = new DefaultOutputQueryParam(2, UnknownDbType.getInstance(), "param2");
        LinkedList<DefaultOutputQueryParam> params = new LinkedList<DefaultOutputQueryParam>();
        params.add(param1);
        params.add(param2);
        QueryTemplate queryTemplate = new QueryTemplate("dummy", QueryType.STORE_PROCEDURE_CALL, params);
        StatementResultIterator iterator = new StatementResultIterator(this.connection, (Statement)this.statement, queryTemplate, (AutoGeneratedKeyStrategy)new NoAutoGeneratedKeyStrategy(), null);
        iterator.next();
        iterator.next();
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.statement});
        ((CallableStatement)inOrder.verify((Object)this.statement)).getObject(1);
        ((CallableStatement)inOrder.verify((Object)this.statement)).getObject(2);
    }

    @Test
    public void cachesHasNext() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.statement.getResultSet()).thenReturn((Object)resultSet);
        this.iterator.hasNext();
        boolean hasNext = this.iterator.hasNext();
        Assert.assertThat((Object)hasNext, (Matcher)CoreMatchers.equalTo((Object)true));
        ((CallableStatement)Mockito.verify((Object)this.statement)).getResultSet();
    }

    @Test
    public void clearsCacheOnNextInvocation() throws Exception {
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.statement.getResultSet()).thenReturn((Object)resultSet);
        this.iterator.hasNext();
        this.iterator.next();
        boolean hasNext = this.iterator.hasNext();
        Assert.assertThat((Object)hasNext, (Matcher)CoreMatchers.equalTo((Object)true));
        ((CallableStatement)Mockito.verify((Object)this.statement, (VerificationMode)Mockito.times((int)2))).getResultSet();
    }

    @Test(expected=NoSuchElementException.class)
    public void throwsExceptionWhenNoElementExist() throws Exception {
        Mockito.when((Object)this.statement.getUpdateCount()).thenReturn((Object)-1);
        Mockito.when((Object)this.statement.getResultSet()).thenReturn(null);
        this.iterator.next();
    }

    @Test
    public void returnsMultipleResultSetsWhenStreamingIsSupported() throws Exception {
        this.mockConnectionMetaData(true);
        Mockito.when((Object)this.resultSetHandler.requiresMultipleOpenedResults()).thenReturn((Object)true);
        ResultSet resultSet1 = (ResultSet)Mockito.mock(ResultSet.class);
        ResultSet resultSet2 = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.statement.getResultSet()).thenReturn((Object)resultSet1).thenReturn((Object)resultSet2);
        StatementResult result1 = this.iterator.next();
        StatementResult result2 = this.iterator.next();
        Assert.assertThat((Object)result1.getResult(), (Matcher)Is.is((Object)resultSet1));
        Assert.assertThat((Object)result2.getResult(), (Matcher)Is.is((Object)resultSet2));
    }

    @Test(expected=IllegalStateException.class)
    public void failsAfterGettingResultSetWhenStreamingIsUnsupported() throws Exception {
        this.mockConnectionMetaData(false);
        Mockito.when((Object)this.resultSetHandler.requiresMultipleOpenedResults()).thenReturn((Object)true);
        ResultSet resultSet = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)this.statement.getResultSet()).thenReturn((Object)resultSet);
        this.iterator.next();
        this.iterator.next();
    }

    private void mockConnectionMetaData(Boolean supportsMultipleOpenResults) throws SQLException {
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)metaData.supportsMultipleOpenResults()).thenReturn((Object)supportsMultipleOpenResults);
        Mockito.when((Object)this.connection.getMetaData()).thenReturn((Object)metaData);
    }
}

