/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.test.util;

import java.util.ArrayList;
import java.util.List;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.domain.type.UnknownDbTypeException;

public class DbTypeManagerBuilder {
    private DbConnection connection;
    private List<DbType> types = new ArrayList<DbType>();
    private List<DbType> unknownTypes = new ArrayList<DbType>();

    public DbTypeManagerBuilder on(DbConnection connection) {
        this.connection = connection;
        return this;
    }

    public DbTypeManagerBuilder managing(DbType type) {
        this.types.add(type);
        return this;
    }

    public DbTypeManagerBuilder unknowing(DbType type) {
        this.unknownTypes.add(type);
        return this;
    }

    public DbTypeManager build() {
        DbTypeManager dbTypeManager = (DbTypeManager)Mockito.mock(DbTypeManager.class);
        for (DbType type : this.types) {
            Mockito.when((Object)dbTypeManager.lookup(this.connection, type.getId(), type.getName())).thenReturn((Object)type);
        }
        for (DbType type : this.unknownTypes) {
            Mockito.when((Object)dbTypeManager.lookup(this.connection, type.getId(), type.getName())).thenThrow(new Throwable[]{new UnknownDbTypeException(type.getId(), type.getName())});
        }
        return dbTypeManager;
    }
}

