/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.test.util;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.mule.module.db.test.util.ColumnMetadata;
import org.mule.module.db.test.util.InMemoryResultSet;

public class ResultSetBuilder {
    private final List<ColumnMetadata> columns;
    private final List<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
    private final Statement statement;

    public ResultSetBuilder(List<ColumnMetadata> columns) {
        this(columns, null);
    }

    public ResultSetBuilder(List<ColumnMetadata> columns, Statement statement) {
        this.columns = columns;
        this.statement = statement;
    }

    public ResultSetBuilder with(Map<String, Object> record) {
        this.records.add(record);
        return this;
    }

    public ResultSetBuilder with(List<Map<String, Object>> records) {
        this.records.addAll(records);
        return this;
    }

    public ResultSet build() {
        return new InMemoryResultSet(this.columns, this.records, this.statement);
    }
}

