/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.connection;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.api.transaction.Transaction;
import org.mule.api.transaction.TransactionException;
import org.mule.module.db.internal.domain.connection.ConnectionBindingException;
import org.mule.module.db.internal.domain.connection.ConnectionClosingException;
import org.mule.module.db.internal.domain.connection.ConnectionCommitException;
import org.mule.module.db.internal.domain.connection.ConnectionCreationException;
import org.mule.module.db.internal.domain.connection.ConnectionFactory;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.connection.DefaultDbConnection;
import org.mule.module.db.internal.domain.connection.DefaultDbConnectionReleaser;
import org.mule.module.db.internal.domain.transaction.DbTransactionManager;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.domain.type.DbTypeManager;
import org.mule.module.db.internal.resolver.param.GenericParamTypeResolverFactory;

public class TransactionalDbConnectionFactory
implements DbConnectionFactory {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected final DbTransactionManager dbTransactionManager;
    protected final DbTypeManager dbTypeManager;
    private final ConnectionFactory connectionFactory;
    private final DataSource dataSource;

    public TransactionalDbConnectionFactory(DbTransactionManager dbTransactionManager, DbTypeManager dbTypeManager, ConnectionFactory connectionFactory, DataSource dataSource) {
        this.dbTransactionManager = dbTransactionManager;
        this.dbTypeManager = dbTypeManager;
        this.connectionFactory = connectionFactory;
        this.dataSource = dataSource;
    }

    @Override
    public DbConnection createConnection(TransactionalAction transactionalAction) throws SQLException {
        Connection connection;
        try {
            connection = this.createDataSourceConnection(transactionalAction);
        }
        catch (ConnectionCreationException e) {
            throw new SQLException(e);
        }
        return this.doCreateDbConnection(connection, transactionalAction);
    }

    private Connection createDataSourceConnection(TransactionalAction transactionalAction) throws SQLException {
        Connection connection;
        Transaction tx = this.dbTransactionManager.getTransaction();
        if (transactionalAction == TransactionalAction.ALWAYS_JOIN) {
            if (tx == null) {
                throw new IllegalStateException("Transactional action is " + (Object)((Object)transactionalAction) + " but there is no active transaction");
            }
            connection = this.getConnectionFromTransaction(tx, this.dataSource);
        } else if (transactionalAction == TransactionalAction.JOIN_IF_POSSIBLE) {
            connection = tx == null ? this.connectionFactory.create(this.dataSource) : this.getConnectionFromTransaction(tx, this.dataSource);
        } else if (transactionalAction == TransactionalAction.NOT_SUPPORTED) {
            connection = this.connectionFactory.create(this.dataSource);
        } else {
            throw new IllegalArgumentException("There is no defined way to manage transactional action " + (Object)((Object)transactionalAction));
        }
        return connection;
    }

    protected DbConnection doCreateDbConnection(Connection connection, TransactionalAction transactionalAction) {
        return new DefaultDbConnection(connection, transactionalAction, new DefaultDbConnectionReleaser(this), new GenericParamTypeResolverFactory(this.dbTypeManager));
    }

    private Connection getConnectionFromTransaction(Transaction tx, DataSource dataSource) throws SQLException {
        Connection con;
        if (tx.hasResource((Object)dataSource)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Retrieving connection from current transaction: " + tx));
            }
            con = (Connection)tx.getResource((Object)dataSource);
        } else {
            con = this.connectionFactory.create(dataSource);
            try {
                tx.bindResource((Object)dataSource, (Object)con);
            }
            catch (TransactionException e) {
                if (con != null && !con.isClosed()) {
                    con.close();
                }
                throw new ConnectionBindingException("Could not bind connection to current transaction: " + tx, e);
            }
        }
        return con;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseConnection(DbConnection connection) {
        if (connection == null) {
            return;
        }
        try {
            if (connection.isClosed()) {
                return;
            }
        }
        catch (SQLException e) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Error checking for closed connection on releasing connection", (Throwable)e);
            }
            return;
        }
        Transaction transaction = this.dbTransactionManager.getTransaction();
        boolean closeConnection = false;
        if (connection.getTransactionalAction() == TransactionalAction.NOT_SUPPORTED) {
            closeConnection = true;
        } else if (connection.getTransactionalAction() == TransactionalAction.JOIN_IF_POSSIBLE && transaction == null) {
            closeConnection = true;
        }
        if (closeConnection) {
            RuntimeException exception = null;
            try {
                if (!connection.getAutoCommit()) {
                    connection.commit();
                }
            }
            catch (SQLException e) {
                exception = new ConnectionCommitException(e);
            }
            finally {
                block23: {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        if (exception != null) break block23;
                        exception = new ConnectionClosingException(e);
                    }
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }
}

