/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.Collections;
import java.util.List;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MessagingException;
import org.mule.api.MuleMessage;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;

public class SelectStreamingExceptionTestCase
extends AbstractDbIntegrationTestCase {
    private static final int POOL_CONNECTIONS = 2;

    public SelectStreamingExceptionTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Collections.singletonList(new Object[]{"integration/config/derby-pooling-db-config.xml", new DerbyTestDatabase()});
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-streaming-exception-config.xml"};
    }

    @Override
    protected DataSource getDefaultDataSource() {
        DbConfigResolver dbConfigResolver = (DbConfigResolver)muleContext.getRegistry().get("pooledJdbcConfig");
        DbConfig config = this.resolveConfig(dbConfigResolver);
        return config.getDataSource();
    }

    @Test
    public void streamingException() throws Exception {
        for (int i = 0; i < 3; ++i) {
            try {
                this.runFlow("selectStreamingException", "Test Message");
                Assert.fail((String)"Expected 'Table does not exist' exception.");
                continue;
            }
            catch (MessagingException e) {
                Assert.assertThat((String)("Iteration " + i), (Object)e.getMessage(), (Matcher)CoreMatchers.is((Object)"Table/View 'NOT_EXISTS' does not exist. (java.sql.SQLSyntaxErrorException)."));
            }
        }
    }

    @Test
    public void selectExceptionClosesPreviousResultSets() throws Exception {
        MuleMessage response = this.runFlow("selectExceptionClosesPreviousResultSets").getMessage();
        Assert.assertThat((Object)response.getPayload(), (Matcher)CoreMatchers.is((Object)Boolean.FALSE));
    }
}

