/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.update;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.api.debug.FieldDebugInfo;
import org.mule.construct.Flow;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Planet;
import org.mule.module.db.internal.domain.query.Query;
import org.mule.module.db.internal.domain.query.QueryType;
import org.mule.module.db.internal.processor.AbstractDbMessageProcessor;
import org.mule.tck.junit4.matcher.FieldDebugInfoMatcher;
import org.mule.tck.junit4.matcher.ObjectDebugInfoMatcher;

public class UpdateBulkParameterizedDebugInfoTestCase
extends AbstractDbIntegrationTestCase {
    public static final String PARAM1 = "param 1";
    public static final String PARAM_SET1 = "Param set 1";
    public static final String PARAM_SET2 = "Param set 2";

    public UpdateBulkParameterizedDebugInfoTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/update/update-bulk-config.xml"};
    }

    @Test
    public void providesDebugInfo() throws Exception {
        Flow flowConstruct = (Flow)muleContext.getRegistry().lookupFlowConstruct("updateBulk");
        List messageProcessors = flowConstruct.getMessageProcessors();
        AbstractDbMessageProcessor queryMessageProcessor = (AbstractDbMessageProcessor)messageProcessors.get(0);
        ArrayList<String> planetNames = new ArrayList<String>();
        planetNames.add(Planet.EARTH.getName());
        planetNames.add(Planet.MARS.getName());
        MuleEvent muleEvent = UpdateBulkParameterizedDebugInfoTestCase.getTestEvent(planetNames);
        List debugInfo = queryMessageProcessor.getDebugInfo(muleEvent);
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.nullValue())));
        MatcherAssert.assertThat((Object)debugInfo.size(), (Matcher)Matchers.equalTo((Object)2));
        ArrayList<Matcher> queryMatcher = new ArrayList<Matcher>();
        queryMatcher.add(FieldDebugInfoMatcher.fieldLike((String)"SQL", String.class, (Object)"update PLANET set NAME='Mercury' where NAME=?"));
        queryMatcher.add(FieldDebugInfoMatcher.fieldLike((String)"Type", String.class, (Object)QueryType.UPDATE.toString()));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Query", Query.class, queryMatcher)));
        MatcherAssert.assertThat((Object)debugInfo, (Matcher)Matchers.hasItem((Matcher)ObjectDebugInfoMatcher.objectLike((String)"Input params", List.class, this.createExpectedParamSetMatchers())));
    }

    private List<Matcher<FieldDebugInfo<?>>> createExpectedParamSetMatchers() {
        ArrayList paramSetMatchers = new ArrayList();
        ArrayList<Matcher> paramSet1 = new ArrayList<Matcher>();
        paramSet1.add(FieldDebugInfoMatcher.fieldLike((String)PARAM1, String.class, (Object)Planet.EARTH.getName()));
        paramSetMatchers.add(ObjectDebugInfoMatcher.objectLike((String)PARAM_SET1, List.class, paramSet1));
        ArrayList<Matcher> paramSet2 = new ArrayList<Matcher>();
        paramSet2.add(FieldDebugInfoMatcher.fieldLike((String)PARAM1, String.class, (Object)Planet.MARS.getName()));
        paramSetMatchers.add(ObjectDebugInfoMatcher.objectLike((String)PARAM_SET2, List.class, paramSet2));
        return paramSetMatchers;
    }
}

