/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.xa;

import java.util.ArrayList;
import java.util.Collection;
import javax.sql.DataSource;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.mule.api.MuleContext;
import org.mule.module.db.internal.domain.xa.CompositeDataSourceDecorator;
import org.mule.module.db.internal.domain.xa.DataSourceDecorator;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
@RunWith(value=MockitoJUnitRunner.class)
public class CompositeDataSourceDecoratorTestCase
extends AbstractMuleTestCase {
    public static final String DATA_SOURCE_NAME = "name";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private MuleContext mockMuleContext;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DataSourceDecorator mockFirstDataSourceDecorator;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DataSourceDecorator mockSecondDataSourceDecorator;
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private DataSource mockDataSource;
    private CompositeDataSourceDecorator decorator;

    @Before
    public void prepareCompositeDataSourceDecorator() {
        this.decorator = new CompositeDataSourceDecorator();
        Mockito.when((Object)this.mockMuleContext.getRegistry().lookupObjects(DataSourceDecorator.class)).thenReturn(this.getDecoratorMocks());
        this.decorator.init(this.mockMuleContext);
    }

    @Test
    public void appliesStopsAfterFirstPositive() {
        Mockito.when((Object)this.mockFirstDataSourceDecorator.appliesTo(this.mockDataSource, this.mockMuleContext)).thenReturn((Object)true);
        this.decorator.decorate(this.mockDataSource, DATA_SOURCE_NAME, null, this.mockMuleContext);
        ((DataSourceDecorator)Mockito.verify((Object)this.mockFirstDataSourceDecorator)).appliesTo(this.mockDataSource, this.mockMuleContext);
        ((DataSourceDecorator)Mockito.verify((Object)this.mockSecondDataSourceDecorator, (VerificationMode)Mockito.never())).appliesTo(this.mockDataSource, this.mockMuleContext);
    }

    @Test
    public void ifFirstAppliesIsFalseContinueWithNext() {
        Mockito.when((Object)this.mockFirstDataSourceDecorator.appliesTo(this.mockDataSource, this.mockMuleContext)).thenReturn((Object)false);
        this.decorator.decorate(this.mockDataSource, DATA_SOURCE_NAME, null, this.mockMuleContext);
        ((DataSourceDecorator)Mockito.verify((Object)this.mockFirstDataSourceDecorator)).appliesTo(this.mockDataSource, this.mockMuleContext);
        ((DataSourceDecorator)Mockito.verify((Object)this.mockSecondDataSourceDecorator)).appliesTo(this.mockDataSource, this.mockMuleContext);
    }

    private Collection<DataSourceDecorator> getDecoratorMocks() {
        ArrayList<DataSourceDecorator> decorators = new ArrayList<DataSourceDecorator>();
        decorators.add(this.mockSecondDataSourceDecorator);
        decorators.add(this.mockFirstDataSourceDecorator);
        return decorators;
    }
}

