/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.el;

import java.sql.SQLException;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.mockito.Mockito;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.registry.MuleRegistry;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.connection.DbConnectionFactory;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.domain.transaction.TransactionalAction;
import org.mule.module.db.internal.el.AbstractDbFunction;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.tck.junit4.AbstractMuleTestCase;

public abstract class AbstractDbCreateFunctionTestCase
extends AbstractMuleTestCase {
    protected static final String DB_CONFIG_NAME = "dbConfig";
    protected static final String TYPE_NAME = "TEST_ARRAY";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private final MuleContext muleContext = (MuleContext)Mockito.mock(MuleContext.class);
    protected final ExpressionLanguageContext context = (ExpressionLanguageContext)Mockito.mock(ExpressionLanguageContext.class);
    protected final AbstractDbFunction function = this.createDbFunction(this.muleContext);

    @Test
    public void validatesNumberOfParameters() throws Exception {
        Object[] params = new Object[]{DB_CONFIG_NAME, TYPE_NAME};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.function.createInvalidArgumentCountMessage(2));
        this.function.call(params, this.context);
    }

    @Test
    public void validatesFirstParameterIsAString() throws Exception {
        Object[] params = new Object[]{new Object(), TYPE_NAME, new Object[0]};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.function.createInvalidDbConfigNameArgument());
        this.function.call(params, this.context);
    }

    @Test
    public void validatesSecondParameterIsAString() throws Exception {
        Object[] params = new Object[]{DB_CONFIG_NAME, new Object(), new Object[0]};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.function.createInvalidDbTypeMessage());
        this.function.call(params, this.context);
    }

    @Test
    public void validatesThirdParameterType() throws Exception {
        Object[] params = new Object[]{DB_CONFIG_NAME, TYPE_NAME, new Object()};
        this.expectedException.expect(IllegalArgumentException.class);
        this.expectedException.expectMessage(this.function.createInvalidStructValuesArgument());
        this.function.call(params, this.context);
    }

    @Test
    public void requiresActiveTransaction() throws Exception {
        Object[] structValues = new Object[]{"foo", "bar"};
        Object[] params = new Object[]{DB_CONFIG_NAME, TYPE_NAME, structValues};
        this.expectedException.expect(IllegalStateException.class);
        this.createDbConnection(false);
        this.function.call(params, this.context);
    }

    protected abstract AbstractDbFunction createDbFunction(MuleContext var1);

    protected DbConnection createDbConnection(boolean withTransaction) throws SQLException {
        MuleEvent event = (MuleEvent)Mockito.mock(MuleEvent.class);
        MuleRegistry muleRegistry = (MuleRegistry)Mockito.mock(MuleRegistry.class);
        DbConfigResolver dbConfigResolver = (DbConfigResolver)Mockito.mock(DbConfigResolver.class);
        DbConfig dbConfig = (DbConfig)Mockito.mock(DbConfig.class);
        DbConnection dbConnection = (DbConnection)Mockito.mock(DbConnection.class);
        DbConnectionFactory dbConnectionFactory = (DbConnectionFactory)Mockito.mock(DbConnectionFactory.class);
        Mockito.when((Object)this.context.getVariable("_muleEvent")).thenReturn((Object)event);
        Mockito.when((Object)this.muleContext.getRegistry()).thenReturn((Object)muleRegistry);
        Mockito.when((Object)muleRegistry.get(DB_CONFIG_NAME)).thenReturn((Object)dbConfigResolver);
        Mockito.when((Object)dbConfigResolver.resolve(event)).thenReturn((Object)dbConfig);
        Mockito.when((Object)dbConfig.getConnectionFactory()).thenReturn((Object)dbConnectionFactory);
        if (withTransaction) {
            Mockito.when((Object)dbConnectionFactory.createConnection(TransactionalAction.ALWAYS_JOIN)).thenReturn((Object)dbConnection);
        } else {
            Mockito.when((Object)dbConnectionFactory.createConnection(TransactionalAction.ALWAYS_JOIN)).thenThrow(new Throwable[]{new IllegalStateException("No transaction")});
        }
        return dbConnection;
    }
}

