/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.module.db.integration.DbTestUtil;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.Record;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;
import org.mule.tck.junit4.FunctionalTestCase;

@RunWith(value=Parameterized.class)
public abstract class AbstractDbIntegrationTestCase
extends FunctionalTestCase {
    private final String dataSourceConfigResource;
    protected final AbstractTestDatabase testDatabase;

    public AbstractDbIntegrationTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        this.dataSourceConfigResource = dataSourceConfigResource;
        this.testDatabase = testDatabase;
    }

    @Before
    public void configDB() throws SQLException {
        this.testDatabase.createDefaultDatabaseConfig(this.getDefaultDataSource());
    }

    protected DataSource getDefaultDataSource() {
        DbConfigResolver dbConfigResolver = (DbConfigResolver)muleContext.getRegistry().get("dbConfig");
        DbConfig config = this.resolveConfig(dbConfigResolver);
        return config.getDataSource();
    }

    protected DbConfig resolveConfig(DbConfigResolver dbConfigResolver) {
        return dbConfigResolver.resolve(null);
    }

    protected final String[] getConfigFiles() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getDatasourceConfigurationResource());
        for (String resource : this.getFlowConfigurationResources()) {
            if (builder.length() != 0) {
                builder.append(",");
            }
            builder.append(resource);
        }
        return builder.toString().split(",");
    }

    protected final String getDatasourceConfigurationResource() {
        return this.dataSourceConfigResource;
    }

    protected abstract String[] getFlowConfigurationResources();

    protected void assertPlanetRecordsFromQuery(String ... names) throws SQLException {
        if (names.length == 0) {
            throw new IllegalArgumentException("Must provide at least a name to query on the DB");
        }
        StringBuilder conditionBuilder = new StringBuilder();
        ArrayList<Record> records = new ArrayList<Record>(names.length);
        for (String name : names) {
            if (conditionBuilder.length() != 0) {
                conditionBuilder.append(",");
            }
            conditionBuilder.append("'").append(name).append("'");
            records.add(new Record(new Field("NAME", name)));
        }
        List result = DbTestUtil.selectData(String.format("select * from PLANET where name in (%s)", conditionBuilder.toString()), this.getDefaultDataSource());
        TestRecordUtil.assertRecords(result, records.toArray(new Record[0]));
    }

    protected void assertDeletedPlanetRecords(String ... names) throws SQLException {
        if (names.length == 0) {
            throw new IllegalArgumentException("Must provide at least a name to query on the DB");
        }
        StringBuilder conditionBuilder = new StringBuilder();
        for (String name : names) {
            if (conditionBuilder.length() != 0) {
                conditionBuilder.append(",");
            }
            conditionBuilder.append("'").append(name).append("'");
        }
        List result = DbTestUtil.selectData(String.format("select * from PLANET where name in (%s)", conditionBuilder.toString()), this.getDefaultDataSource());
        Assert.assertThat((Object)result.size(), (Matcher)CoreMatchers.equalTo((Object)0));
    }
}

