/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.config;

import java.util.Collections;
import java.util.List;
import org.enhydra.jdbc.standard.StandardDataSource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleEvent;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.DerbyTestDatabase;
import org.mule.module.db.internal.domain.database.DbConfig;
import org.mule.module.db.internal.resolver.database.DbConfigResolver;

public class GenericDbConfigTestCase
extends AbstractDbIntegrationTestCase {
    private static final String EXPECTED_DRIVER_CLASSNAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String EXPECTED_URL = "jdbc:derby:target/muleEmbeddedDB;sql.enforce_strict_size=true;create=true";
    private static final String EXPECTED_PASSWORD = "passwordTest";
    private static final String EXPECTED_USER = "userTest";

    public GenericDbConfigTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return Collections.singletonList(new Object[]{"integration/config/generic-db-config.xml", new DerbyTestDatabase()});
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[0];
    }

    @Test
    public void configPropertiesAreTheExpected() throws Exception {
        MuleEvent muleEvent = GenericDbConfigTestCase.getTestEvent((Object)"Test Message");
        DbConfig dbConfig = ((DbConfigResolver)muleContext.getRegistry().lookupObject("dbConfig")).resolve(muleEvent);
        StandardDataSource dataSource = (StandardDataSource)dbConfig.getDataSource();
        MatcherAssert.assertThat((Object)dataSource.getUser(), (Matcher)CoreMatchers.equalTo((Object)EXPECTED_USER));
        MatcherAssert.assertThat((Object)dataSource.getPassword(), (Matcher)CoreMatchers.equalTo((Object)EXPECTED_PASSWORD));
        MatcherAssert.assertThat((Object)dataSource.getUrl(), (Matcher)CoreMatchers.equalTo((Object)EXPECTED_URL));
        MatcherAssert.assertThat((Object)dataSource.getDriverName(), (Matcher)CoreMatchers.equalTo((Object)EXPECTED_DRIVER_CLASSNAME));
    }
}

