/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.config;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import org.apache.derby.jdbc.EmbeddedDriver;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.model.AbstractTestDatabase;

public class StalePooledConnectionResetTestCase
extends AbstractDbIntegrationTestCase {
    public StalePooledConnectionResetTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getDerbyResource();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/config/derby-db-pool-reset-config.xml"};
    }

    @Test
    public void resetsStalePooledConnection() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://testIn", (Object)"Test Message", null);
        MatcherAssert.assertThat((Object)response.getExceptionPayload(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
        this.stopDatabase();
        this.startDatabase();
        response = client.send("vm://testIn", (Object)"Test Message", null);
        MatcherAssert.assertThat((Object)response.getExceptionPayload(), (Matcher)Matchers.is((Matcher)Matchers.nullValue()));
    }

    private void startDatabase() throws SQLException {
        DriverManager.registerDriver((Driver)new EmbeddedDriver());
    }

    private void stopDatabase() {
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            Assert.fail((String)"Expected to throw an exception while shutting down the database");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

