/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.LinkedList;
import java.util.List;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.module.db.integration.model.Field;
import org.mule.module.db.integration.model.OracleTestDatabase;
import org.mule.module.db.integration.model.Record;
import org.mule.module.db.integration.model.RegionManager;

public class SelectJavaUdtTestCase
extends AbstractDbIntegrationTestCase {
    public SelectJavaUdtTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        LinkedList<Object[]> params = new LinkedList<Object[]>();
        if (!TestDbConfig.getOracleResource().isEmpty()) {
            params.add(new Object[]{"integration/config/oracle-mapped-udt-db-config.xml", new OracleTestDatabase()});
        }
        if (!TestDbConfig.getDerbyResource().isEmpty()) {
            params.add(TestDbConfig.getDerbyResource().get(0));
        }
        return params;
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-udt-config.xml"};
    }

    @Test
    public void returnsMappedObject() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://returnsUDT", (Object)"Test Message", null);
        TestRecordUtil.assertRecords(response.getPayload(), new Record(new Field("REGION_NAME", RegionManager.SOUTHWEST_MANAGER.getRegionName()), new Field("MANAGER_NAME", RegionManager.SOUTHWEST_MANAGER.getName()), new Field("DETAILS", RegionManager.SOUTHWEST_MANAGER.getContactDetails())), new Record(new Field("REGION_NAME", RegionManager.NORTHWEST_MANAGER.getRegionName()), new Field("MANAGER_NAME", RegionManager.NORTHWEST_MANAGER.getName()), new Field("DETAILS", RegionManager.NORTHWEST_MANAGER.getContactDetails())));
    }
}

