/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.integration.select;

import java.util.List;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.api.MuleMessage;
import org.mule.api.client.LocalMuleClient;
import org.mule.module.db.integration.AbstractDbIntegrationTestCase;
import org.mule.module.db.integration.TestDbConfig;
import org.mule.module.db.integration.TestRecordUtil;
import org.mule.module.db.integration.model.AbstractTestDatabase;
import org.mule.tck.junit4.rule.SystemProperty;

public class SelectMaxRowsTestCase
extends AbstractDbIntegrationTestCase {
    @Rule
    public SystemProperty maxRows = new SystemProperty("maxRows", "2");

    public SelectMaxRowsTestCase(String dataSourceConfigResource, AbstractTestDatabase testDatabase) {
        super(dataSourceConfigResource, testDatabase);
    }

    @Parameterized.Parameters
    public static List<Object[]> parameters() {
        return TestDbConfig.getResources();
    }

    @Override
    protected String[] getFlowConfigurationResources() {
        return new String[]{"integration/select/select-max-rows-config.xml"};
    }

    @Test
    public void limitsRows() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://selectMaxRows", (Object)"Test Message", null);
        TestRecordUtil.assertMessageContains(response, TestRecordUtil.getVenusRecord(), TestRecordUtil.getEarthRecord());
    }

    @Test
    public void limitsStreamedRows() throws Exception {
        LocalMuleClient client = muleContext.getClient();
        MuleMessage response = client.send("vm://selectMaxStreamedRows", (Object)"Test Message", null);
        TestRecordUtil.assertMessageContains(response, TestRecordUtil.getVenusRecord(), TestRecordUtil.getEarthRecord());
    }
}

