/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.util.Arrays;
import java.util.Collection;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.tck.junit4.AbstractMuleTestCase;

@RunWith(value=Parameterized.class)
public class BigDecimalDbTypeTestCase
extends AbstractMuleTestCase {
    private final PreparedStatement statement = (PreparedStatement)Mockito.mock(PreparedStatement.class);
    private final ResolvedDbType resolvedDbType;
    private final int sqlType;

    public BigDecimalDbTypeTestCase(int sqlType) {
        this.sqlType = sqlType;
        this.resolvedDbType = new ResolvedDbType(sqlType, "BigDecimalDbType");
    }

    @Parameterized.Parameters
    public static Collection<Object> data() {
        return Arrays.asList(3, 2);
    }

    @Test
    public void setBigDecimalValue() throws Exception {
        int index = 0;
        BigDecimal bigDecimalValue = new BigDecimal(1234.1234);
        this.resolvedDbType.setParameterValue(this.statement, index, (Object)bigDecimalValue);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(index, (Object)bigDecimalValue, this.sqlType, bigDecimalValue.scale());
    }

    @Test
    public void setBigDecimalValueFromDouble() throws Exception {
        Double doubleValue = 1234.1234;
        this.verifyScale(doubleValue, 4);
    }

    @Test
    public void setBigDecimalValueFromFloat() throws Exception {
        Float floatValue = Float.valueOf(1234.1234f);
        this.verifyScale(floatValue, 4);
    }

    @Test
    public void setBigDecimalValueFromInteger() throws Exception {
        Integer integerValue = 1234;
        this.resolvedDbType.setParameterValue(this.statement, 0, (Object)integerValue);
        ((PreparedStatement)Mockito.verify((Object)this.statement)).setObject(Matchers.anyInt(), Matchers.anyObject(), Matchers.anyInt());
    }

    private void verifyScale(Object value, int scale) throws Exception {
        final BigDecimal[] bigDecimal = new BigDecimal[1];
        ((PreparedStatement)Mockito.doAnswer((Answer)new Answer(){

            public Object answer(InvocationOnMock invocation) throws Throwable {
                bigDecimal[0] = (BigDecimal)invocation.getArguments()[1];
                return null;
            }
        }).when((Object)this.statement)).setObject(Matchers.anyInt(), Matchers.anyObject(), Matchers.anyInt(), Matchers.anyInt());
        this.resolvedDbType.setParameterValue(this.statement, 0, value);
        Assert.assertThat((Object)bigDecimal[0].scale(), (Matcher)CoreMatchers.is((Object)scale));
    }
}

