/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.db.internal.domain.type;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import junit.framework.TestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mule.module.db.internal.domain.connection.DbConnection;
import org.mule.module.db.internal.domain.type.BlobResolvedDataType;
import org.mule.module.db.internal.domain.type.ClobResolvedDataType;
import org.mule.module.db.internal.domain.type.DbType;
import org.mule.module.db.internal.domain.type.MetadataDbTypeManager;
import org.mule.module.db.internal.domain.type.ResolvedDbType;
import org.mule.module.db.internal.domain.type.UnknownDbTypeException;
import org.mule.module.db.test.util.ColumnMetadata;
import org.mule.module.db.test.util.ResultSetBuilder;
import org.mule.tck.junit4.AbstractMuleTestCase;
import org.mule.tck.size.SmallTest;

@SmallTest
public class MetadataDbTypeManagerTestCase
extends AbstractMuleTestCase {
    private static final DbType UDT_ARRAY = new ResolvedDbType(2003, "UDT_ARRAY");
    private static final DbType UDT_DISTINCT = new ResolvedDbType(2001, "UDT_DISTINCT");
    private static final DbType UDT_STRUCT = new ResolvedDbType(2002, "UDT_STRUCT");
    private static final DbType UDT_OK = new ResolvedDbType(1, "UDT_OK");
    private static final DbType UDT_CLOB = new ResolvedDbType(2005, "CLOB");
    private static final DbType UDT_BLOB = new ResolvedDbType(2004, "BLOB");

    @Test
    public void ignoreUserDefinedTypes() throws Exception {
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)metaData.getTypeInfo()).thenReturn((Object)this.createResultSetWithUserDefinedTypes());
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metaData);
        MetadataDbTypeManager typeManager = new MetadataDbTypeManager();
        Assert.assertThat((Object)typeManager.lookup(connection, UDT_OK.getId(), UDT_OK.getName()), (Matcher)CoreMatchers.instanceOf(DbType.class));
        this.assertNotContainsUserDefinedType(typeManager, connection, UDT_ARRAY);
        this.assertNotContainsUserDefinedType(typeManager, connection, UDT_DISTINCT);
        this.assertNotContainsUserDefinedType(typeManager, connection, UDT_STRUCT);
    }

    @Test
    public void resolveBlobDatatype() throws Exception {
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)metaData.getTypeInfo()).thenReturn((Object)this.createResultSetWithBlobType());
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metaData);
        MetadataDbTypeManager typeManager = new MetadataDbTypeManager();
        typeManager.initialise(connection);
        Assert.assertThat((Object)typeManager.lookup(connection, 2004, "BLOB"), (Matcher)CoreMatchers.instanceOf(BlobResolvedDataType.class));
    }

    @Test
    public void resolveClobDatatype() throws Exception {
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)metaData.getTypeInfo()).thenReturn((Object)this.createResultSetWithClobType());
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metaData);
        MetadataDbTypeManager typeManager = new MetadataDbTypeManager();
        typeManager.initialise(connection);
        Assert.assertThat((Object)typeManager.lookup(connection, 2005, "CLOB"), (Matcher)CoreMatchers.instanceOf(ClobResolvedDataType.class));
    }

    @Test
    public void ignoreDuplicatedTypes() throws Exception {
        DatabaseMetaData metaData = (DatabaseMetaData)Mockito.mock(DatabaseMetaData.class);
        Mockito.when((Object)metaData.getTypeInfo()).thenReturn((Object)this.createResultSetWithDuplicatedTypes());
        DbConnection connection = (DbConnection)Mockito.mock(DbConnection.class);
        Mockito.when((Object)connection.getMetaData()).thenReturn((Object)metaData);
        MetadataDbTypeManager typeManager = new MetadataDbTypeManager();
        Assert.assertThat((Object)typeManager.lookup(connection, UDT_OK.getId(), UDT_OK.getName()), (Matcher)CoreMatchers.instanceOf(DbType.class));
    }

    private void assertNotContainsUserDefinedType(MetadataDbTypeManager typeManager, DbConnection connection, DbType udtDbType) {
        try {
            typeManager.lookup(connection, udtDbType.getId(), udtDbType.getName());
            TestCase.fail((String)"User defined types must not be registered by the MetadataDbTypeManager.");
        }
        catch (UnknownDbTypeException unknownDbTypeException) {
            // empty catch block
        }
    }

    private ResultSet createResultSetWithClobType() throws SQLException {
        List<ColumnMetadata> columns = this.getTypeMedataColumns();
        ResultSetBuilder resultSetBuilder = new ResultSetBuilder(columns, (Statement)Mockito.mock(Statement.class));
        this.addRecord(resultSetBuilder, UDT_CLOB);
        return resultSetBuilder.build();
    }

    private ResultSet createResultSetWithBlobType() throws SQLException {
        List<ColumnMetadata> columns = this.getTypeMedataColumns();
        ResultSetBuilder resultSetBuilder = new ResultSetBuilder(columns, (Statement)Mockito.mock(Statement.class));
        this.addRecord(resultSetBuilder, UDT_BLOB);
        return resultSetBuilder.build();
    }

    private ResultSet createResultSetWithUserDefinedTypes() throws SQLException {
        List<ColumnMetadata> columns = this.getTypeMedataColumns();
        ResultSetBuilder resultSetBuilder = new ResultSetBuilder(columns, (Statement)Mockito.mock(Statement.class));
        this.addRecord(resultSetBuilder, UDT_ARRAY);
        this.addRecord(resultSetBuilder, UDT_DISTINCT);
        this.addRecord(resultSetBuilder, UDT_STRUCT);
        this.addRecord(resultSetBuilder, UDT_OK);
        return resultSetBuilder.build();
    }

    private ResultSet createResultSetWithDuplicatedTypes() throws SQLException {
        List<ColumnMetadata> columns = this.getTypeMedataColumns();
        ResultSetBuilder resultSetBuilder = new ResultSetBuilder(columns, (Statement)Mockito.mock(Statement.class));
        this.addRecord(resultSetBuilder, UDT_OK);
        this.addRecord(resultSetBuilder, UDT_OK);
        return resultSetBuilder.build();
    }

    private List<ColumnMetadata> getTypeMedataColumns() {
        ArrayList<ColumnMetadata> columns = new ArrayList<ColumnMetadata>();
        columns.add(new ColumnMetadata("DATA_TYPE", "DATA_TYPE", 1));
        columns.add(new ColumnMetadata("TYPE_NAME", "TYPE_NAME", 2));
        return columns;
    }

    private void addRecord(ResultSetBuilder resultSetBuilder, DbType dbType) {
        HashMap<String, Object> record = new HashMap<String, Object>();
        record.put("DATA_TYPE", dbType.getId());
        record.put("TYPE_NAME", dbType.getName());
        resultSetBuilder.with(record);
    }
}

